/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.sql;

import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.rdb.adapter.BaseRdbTypeAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.UpdateSqlHandler;

public class IndexInsertSql
extends UpdateSqlHandler {
    private static final String TMP_TABLE_ALIAS = "tt";

    public String searchByOid(int tenantId, MetaGRdbPropertyStore.GRdbPropertyStoreHandler colDef, String oid, RdbAdapter rdbAdaptor) {
        EntityHandler eh = colDef.getPropertyRuntime().getParent();
        String objDefId = eh.getMetaData().getId();
        IndexType type = colDef.getPropertyRuntime().getMetaData().getIndexType();
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT VAL FROM ");
        if (type == IndexType.NON_UNIQUE) {
            sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_INDEX(colDef.getSingleColumnRdbTypeAdapter().getColOfIndex()));
        } else {
            sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_UNIQUE(colDef.getSingleColumnRdbTypeAdapter().getColOfIndex()));
        }
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdbAdaptor.sanitize(objDefId)).append("'");
        sb.append(" AND OBJ_ID='").append(rdbAdaptor.sanitize(oid)).append("'");
        sb.append(" AND COL_NAME='").append(rdbAdaptor.sanitize(colDef.getExternalIndexColName())).append("'");
        return sb.toString();
    }

    public String insert(int tenantId, final MetaGRdbPropertyStore.GRdbPropertyStoreHandler colDef, String oid, Long version, final Object value, final RdbAdapter rdbAdaptor) {
        EntityHandler eh = colDef.getPropertyRuntime().getParent();
        String objDefId = eh.getMetaData().getId();
        IndexType type = colDef.getPropertyRuntime().getMetaData().getIndexType();
        final StringBuilder sb = new StringBuilder();
        String indexTableName = type == IndexType.NON_UNIQUE ? ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_INDEX(colDef.getSingleColumnRdbTypeAdapter().getColOfIndex()) : ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_UNIQUE(colDef.getSingleColumnRdbTypeAdapter().getColOfIndex());
        this.appendInsertInto(sb, type, indexTableName);
        sb.append(" VALUES(");
        sb.append(tenantId).append(",'");
        sb.append(rdbAdaptor.sanitize(objDefId)).append("','");
        sb.append(rdbAdaptor.sanitize(colDef.getExternalIndexColName())).append("','");
        sb.append(rdbAdaptor.sanitize(oid)).append("'");
        if (type == IndexType.NON_UNIQUE) {
            sb.append(",").append(version);
        }
        sb.append(",");
        if (value != null) {
            colDef.getSingleColumnRdbTypeAdapter().appendToTypedCol(sb, rdbAdaptor, new BaseRdbTypeAdapter.ValueHandleLogic(){

                @Override
                public void run() {
                    colDef.getSingleColumnRdbTypeAdapter().appendToSqlAsRealType(value, sb, rdbAdaptor);
                }
            });
        } else {
            sb.append("null");
        }
        sb.append(")");
        return sb.toString();
    }

    private void appendInsertInto(StringBuilder sb, IndexType type, String indexTableName) {
        sb.append("INSERT INTO ");
        sb.append(indexTableName);
        sb.append("(TENANT_ID,OBJ_DEF_ID,COL_NAME,OBJ_ID");
        if (type == IndexType.NON_UNIQUE) {
            sb.append(",OBJ_VER");
        }
        sb.append(",VAL").append(")");
    }

    public String insertByTempTable(int tenantId, MetaGRdbPropertyStore.GRdbPropertyStoreHandler colDef, RdbAdapter rdbAdaptor) {
        EntityHandler eh = colDef.getPropertyRuntime().getParent();
        String objDefId = eh.getMetaData().getId();
        IndexType type = colDef.getPropertyRuntime().getMetaData().getIndexType();
        StringBuilder sb = new StringBuilder();
        String indexTableName = type == IndexType.NON_UNIQUE ? ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_INDEX(colDef.getSingleColumnRdbTypeAdapter().getColOfIndex()) : ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_UNIQUE(colDef.getSingleColumnRdbTypeAdapter().getColOfIndex());
        this.appendInsertInto(sb, type, indexTableName);
        StringBuilder sbCond = new StringBuilder();
        if (rdbAdaptor.isSupportRowValueConstructor()) {
            sbCond.append("(").append("OBJ_ID").append(",").append("OBJ_VER").append(") IN(").append("SELECT ").append("OBJ_ID").append(",").append("OBJ_VER").append(" FROM ").append(rdbAdaptor.getTemplaryTablePrefix()).append("OBJ_STORE_TMP").append(")");
        } else {
            String objStoreTable = ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE();
            sbCond.append("EXISTS (SELECT 1 FROM ").append(rdbAdaptor.getTemplaryTablePrefix()).append("OBJ_STORE_TMP").append(" ").append(TMP_TABLE_ALIAS).append(" WHERE ").append(TMP_TABLE_ALIAS).append(".").append("OBJ_ID").append("=").append(objStoreTable).append(".").append("OBJ_ID").append(" AND ").append(TMP_TABLE_ALIAS).append(".").append("OBJ_VER").append("=").append(objStoreTable).append(".").append("OBJ_VER");
        }
        this.appendSelect(sb, tenantId, objDefId, ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE(), type, colDef.getExternalIndexColName(), colDef.getMetaData().getPageNo(), colDef.getMetaData().getColumnName(), sbCond.toString(), rdbAdaptor);
        return sb.toString();
    }

    private void appendSelect(StringBuilder sb, int tenantId, String objDefId, String objStoreTableName, IndexType type, String extIndexColName, int pageNo, String colName, CharSequence cond, RdbAdapter rdbAdaptor) {
        sb.append(" SELECT ");
        sb.append(tenantId).append(",'");
        sb.append(rdbAdaptor.sanitize(objDefId)).append("','");
        sb.append(rdbAdaptor.sanitize(extIndexColName)).append("',");
        sb.append("OBJ_ID,");
        if (type == IndexType.NON_UNIQUE) {
            sb.append("OBJ_VER,");
            sb.append(colName);
        } else {
            sb.append("MAX(").append(colName).append(")");
        }
        sb.append(" FROM ");
        sb.append(objStoreTableName);
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdbAdaptor.sanitize(objDefId)).append("'");
        if (cond != null) {
            sb.append(" AND ").append(cond);
        }
        sb.append(" AND PG_NO=").append(pageNo);
        if (type == IndexType.UNIQUE_WITHOUT_NULL || type == IndexType.NON_UNIQUE) {
            sb.append(" AND ").append(colName).append(" IS NOT NULL");
        }
        if (type != IndexType.NON_UNIQUE) {
            sb.append(" GROUP BY TENANT_ID,OBJ_DEF_ID,OBJ_ID");
        }
    }

    public String insertAll(int tenantId, String defId, String tablePostfix, int pageNo, String colName, IndexType type, BaseRdbTypeAdapter colAdapter, RdbAdapter rdbAdaptor) {
        String objTableName = MetaGRdbEntityStore.makeObjStoreName(tablePostfix);
        StringBuilder sb = new StringBuilder();
        String indexTableName = type == IndexType.NON_UNIQUE ? MetaGRdbEntityStore.makeIndexTableName(colAdapter.getColOfIndex(), tablePostfix) : MetaGRdbEntityStore.makeUniqueIndexTableName(colAdapter.getColOfIndex(), tablePostfix);
        String extIndexColName = MetaGRdbPropertyStore.makeExternalIndexColName(pageNo, colName);
        this.appendInsertInto(sb, type, indexTableName);
        this.appendSelect(sb, tenantId, defId, objTableName, type, extIndexColName, pageNo, colName, null, rdbAdaptor);
        return sb.toString();
    }

    public String insertByOid(int tenantId, MetaGRdbPropertyStore.GRdbPropertyStoreHandler colDef, String oid, RdbAdapter rdbAdaptor) {
        EntityHandler eh = colDef.getPropertyRuntime().getParent();
        String objDefId = eh.getMetaData().getId();
        IndexType type = colDef.getPropertyRuntime().getMetaData().getIndexType();
        StringBuilder sb = new StringBuilder();
        String indexTableName = type == IndexType.NON_UNIQUE ? ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_INDEX(colDef.getSingleColumnRdbTypeAdapter().getColOfIndex()) : ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_UNIQUE(colDef.getSingleColumnRdbTypeAdapter().getColOfIndex());
        this.appendInsertInto(sb, type, indexTableName);
        this.appendSelect(sb, tenantId, objDefId, ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE(), type, colDef.getExternalIndexColName(), colDef.getMetaData().getPageNo(), colDef.getMetaData().getColumnName(), "OBJ_ID='" + rdbAdaptor.sanitize(oid) + "'", rdbAdaptor);
        return sb.toString();
    }
}

