/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.impl.datastore.strategy.RecycleBinIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRdbRecycleBinIterator
implements RecycleBinIterator {
    private ResultSet rs;

    public GRdbRecycleBinIterator(ResultSet rs) {
        this.rs = rs;
    }

    @Override
    public boolean next() {
        try {
            return this.rs.next();
        }
        catch (Exception e) {
            throw new EntityRuntimeException(e);
        }
    }

    @Override
    public long getRbid() {
        try {
            return this.rs.getLong("RB_ID");
        }
        catch (Exception e) {
            throw new EntityRuntimeException(e);
        }
    }

    @Override
    public String getOid() {
        try {
            return this.rs.getString("OBJ_ID");
        }
        catch (Exception e) {
            throw new EntityRuntimeException(e);
        }
    }

    @Override
    public String getName() {
        try {
            return this.rs.getString("OBJ_NAME");
        }
        catch (Exception e) {
            throw new EntityRuntimeException(e);
        }
    }

    @Override
    public Timestamp getRbDate() {
        try {
            return this.rs.getTimestamp("RB_DATE");
        }
        catch (Exception e) {
            throw new EntityRuntimeException(e);
        }
    }

    @Override
    public String getRbUser() {
        try {
            return this.rs.getString("RB_USER");
        }
        catch (Exception e) {
            throw new EntityRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Logger logger;
        Statement stmt = null;
        Connection con = null;
        try {
            stmt = this.rs.getStatement();
            con = stmt.getConnection();
            this.rs.close();
        }
        catch (SQLException e) {
            logger = LoggerFactory.getLogger(this.getClass());
            logger.error("Fail to close DB connection Resource. Check whether resource is leak or not.", (Throwable)e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger = LoggerFactory.getLogger(this.getClass());
                    logger.error("Fail to close DB connection Resource. Check whether resource is leak or not.", (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    logger = LoggerFactory.getLogger(this.getClass());
                    logger.error("Fail to close DB connection Resource. Check whether resource is leak or not.", (Throwable)e);
                }
            }
        }
    }
}

