/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.IdentityHashMap;
import java.util.List;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.impl.datastore.RdbBaseValueTypeResolver;
import org.iplass.mtp.impl.datastore.grdb.GRdbPropertyStoreRuntime;
import org.iplass.mtp.impl.datastore.strategy.SearchResultIterator;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyType;
import org.iplass.mtp.impl.rdb.adapter.BaseRdbTypeAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRdbSearchResultIterator
implements SearchResultIterator {
    private ResultSet rs;
    private EntityHandler dataModelHandler;
    private EntityContext context;
    private Query query;
    private RdbAdapter rdb;
    private RdbBaseValueTypeResolver resolver;
    private IdentityHashMap<ValueExpression, Integer> valIndexMap;

    public GRdbSearchResultIterator(ResultSet rs, EntityHandler dataModelHandler, EntityContext context, Query query, RdbAdapter rdb) {
        this.rs = rs;
        this.context = context;
        this.dataModelHandler = dataModelHandler;
        this.query = query;
        this.rdb = rdb;
        this.resolver = new RdbBaseValueTypeResolver(dataModelHandler, context, rdb);
        this.createIndexMap();
    }

    private void createIndexMap() {
        List<ValueExpression> select = this.query.getSelect().getSelectValues();
        this.valIndexMap = new IdentityHashMap(select.size());
        int res = 1;
        for (ValueExpression v : select) {
            this.valIndexMap.put(v, res);
            if (!(v instanceof EntityField)) {
                ++res;
                continue;
            }
            EntityField current = (EntityField)v;
            PropertyHandler ph = this.dataModelHandler.getPropertyCascade(current.getPropertyName(), this.context);
            GRdbPropertyStoreRuntime psh = (GRdbPropertyStoreRuntime)((Object)ph.getStoreSpecProperty());
            res += psh.getColCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Logger logger;
        Statement stmt = null;
        Connection con = null;
        try {
            stmt = this.rs.getStatement();
            con = stmt.getConnection();
            this.rs.close();
        }
        catch (SQLException e) {
            logger = LoggerFactory.getLogger(this.getClass());
            logger.error("Fail to close DB connection Resource. Check whether resource is leak or not.", (Throwable)e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger = LoggerFactory.getLogger(this.getClass());
                    logger.error("Fail to close DB connection Resource. Check whether resource is leak or not.", (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    logger = LoggerFactory.getLogger(this.getClass());
                    logger.error("Fail to close DB connection Resource. Check whether resource is leak or not.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public Object getValue(ValueExpression propName) {
        int colNum = this.getIndex(propName);
        try {
            if (propName instanceof EntityField) {
                PropertyHandler ph = this.dataModelHandler.getPropertyCascade(((EntityField)propName).getPropertyName(), this.context);
                GRdbPropertyStoreRuntime colDef = (GRdbPropertyStoreRuntime)((Object)ph.getStoreSpecProperty());
                return colDef.fromDataStore(this.rs, colNum);
            }
            PropertyType type = this.resolver.resolve(propName);
            if (type == null) {
                return this.rs.getObject(colNum);
            }
            BaseRdbTypeAdapter adapter = this.rdb.getRdbTypeAdapter(type);
            return adapter.fromDataStore(this.rs, colNum);
        }
        catch (SQLException e) {
            throw new EntityRuntimeException(propName + " can not convert.", e);
        }
    }

    private int getIndex(ValueExpression propName) {
        Integer index = this.valIndexMap.get(propName);
        if (index == null) {
            throw new EntityRuntimeException(propName + " is not contains select clause.");
        }
        return index;
    }

    @Override
    public boolean next() {
        try {
            return this.rs.next();
        }
        catch (Exception e) {
            throw new EntityRuntimeException(e);
        }
    }
}

