/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.sql;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.datastore.grdb.GRdbPropertyStoreRuntime;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbMultiplePropertyStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.mapper.ColumnValueMapper;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.mapper.DirectColumnValueMapper;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.mapper.FixedExpressionColumnValueMapper;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.mapper.PropertyColumnValueMapper;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;

public class ObjStoreBulkInsertSql {
    public static List<ColumnValueMapper> insertSubPage(int tenantId, EntityHandler eh, int pageNo, RdbAdapter rdb, EntityContext context) {
        ArrayList<ColumnValueMapper> ret = new ArrayList<ColumnValueMapper>();
        ret.add(new FixedExpressionColumnValueMapper("TENANT_ID", Integer.toString(tenantId)));
        ret.add(new FixedExpressionColumnValueMapper("OBJ_DEF_ID", rdb.toSqlExp(eh.getMetaData().getId())));
        ret.add(new DirectColumnValueMapper("OBJ_ID", "oid", null));
        ret.add(new DirectColumnValueMapper("OBJ_VER", "version", 0L));
        ret.add(new FixedExpressionColumnValueMapper("PG_NO", Integer.toString(pageNo)));
        List<PropertyHandler> propList = eh.getDeclaredPropertyList();
        ObjStoreBulkInsertSql.handlePropList(ret, tenantId, propList, eh, pageNo, rdb);
        return ret;
    }

    private static void handlePropList(List<ColumnValueMapper> mappers, int tenantId, List<PropertyHandler> propList, EntityHandler eh, int pageNo, RdbAdapter rdbAdaptor) {
        for (PropertyHandler p : propList) {
            if (!(p instanceof PrimitivePropertyHandler) || ((PrimitivePropertyHandler)p).getMetaData().getType().isVirtual()) continue;
            GRdbPropertyStoreRuntime colDef = (GRdbPropertyStoreRuntime)((Object)p.getStoreSpecProperty());
            if (!colDef.isMulti()) {
                MetaGRdbPropertyStore.GRdbPropertyStoreHandler scol = (MetaGRdbPropertyStore.GRdbPropertyStoreHandler)colDef;
                if (scol.getMetaData().getPageNo() != pageNo && (scol.getIndexColName() == null || scol.getMetaData().getIndexPageNo() != pageNo)) continue;
                mappers.add(new PropertyColumnValueMapper(tenantId, eh, (PrimitivePropertyHandler)p, pageNo));
                continue;
            }
            MetaGRdbMultiplePropertyStore.GRdbMultiplePropertyStoreHandler mcol = (MetaGRdbMultiplePropertyStore.GRdbMultiplePropertyStoreHandler)colDef;
            boolean isAdd = false;
            for (MetaGRdbPropertyStore metaCol : mcol.getMetaData().getStore()) {
                if (metaCol.getPageNo() != pageNo) continue;
                isAdd = true;
                break;
            }
            if (!isAdd) continue;
            mappers.add(new PropertyColumnValueMapper(tenantId, eh, (PrimitivePropertyHandler)p, pageNo));
        }
    }

    public static List<ColumnValueMapper> insertMain(int tenantId, EntityHandler eh, RdbAdapter rdb, EntityContext context) {
        ArrayList<ColumnValueMapper> ret = new ArrayList<ColumnValueMapper>();
        ret.add(new FixedExpressionColumnValueMapper("TENANT_ID", Integer.toString(tenantId)));
        ret.add(new FixedExpressionColumnValueMapper("OBJ_DEF_ID", rdb.toSqlExp(eh.getMetaData().getId())));
        ret.add(new DirectColumnValueMapper("OBJ_ID", "oid", null));
        ret.add(new DirectColumnValueMapper("OBJ_VER", "version", 0L));
        ret.add(new FixedExpressionColumnValueMapper("PG_NO", "0"));
        ret.add(new FixedExpressionColumnValueMapper("OBJ_DEF_VER", Integer.toString(((MetaGRdbEntityStore)eh.getMetaData().getEntityStoreDefinition()).getVersion())));
        ret.add(new PropertyColumnValueMapper(tenantId, eh, (PrimitivePropertyHandler)eh.getProperty("state", context), 0));
        ret.add(new PropertyColumnValueMapper(tenantId, eh, (PrimitivePropertyHandler)eh.getProperty("name", context), 0));
        ret.add(new PropertyColumnValueMapper(tenantId, eh, (PrimitivePropertyHandler)eh.getProperty("description", context), 0));
        ret.add(new FixedExpressionColumnValueMapper("CRE_DATE", rdb.systimestamp()));
        ret.add(new FixedExpressionColumnValueMapper("UP_DATE", rdb.systimestamp()));
        ret.add(new PropertyColumnValueMapper(tenantId, eh, (PrimitivePropertyHandler)eh.getProperty("startDate", context), 0));
        ret.add(new PropertyColumnValueMapper(tenantId, eh, (PrimitivePropertyHandler)eh.getProperty("endDate", context), 0));
        ret.add(new PropertyColumnValueMapper(tenantId, eh, (PrimitivePropertyHandler)eh.getProperty("lockedBy", context), 0));
        ret.add(new PropertyColumnValueMapper(tenantId, eh, (PrimitivePropertyHandler)eh.getProperty("createBy", context), 0));
        ret.add(new PropertyColumnValueMapper(tenantId, eh, (PrimitivePropertyHandler)eh.getProperty("updateBy", context), 0));
        List<PropertyHandler> propList = eh.getDeclaredPropertyList();
        ObjStoreBulkInsertSql.handlePropList(ret, tenantId, propList, eh, 0, rdb);
        return ret;
    }
}

