/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.definition;

import java.util.List;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.definition.Definition;
import org.iplass.mtp.definition.DefinitionManager;
import org.iplass.mtp.definition.DefinitionModifyResult;
import org.iplass.mtp.definition.DefinitionSummary;
import org.iplass.mtp.definition.TypedDefinitionManager;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.definition.DefinitionService;
import org.iplass.mtp.impl.definition.TypedMetaDataService;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.metadata.RootMetaData;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.transaction.TransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTypedDefinitionManager<D extends Definition>
implements TypedDefinitionManager<D> {
    private DefinitionManager dm = ManagerLocator.getInstance().getManager(DefinitionManager.class);
    private static final Logger logger = LoggerFactory.getLogger(AbstractTypedDefinitionManager.class);

    @Override
    public D get(String definitionName) {
        MetaDataEntry entry = MetaDataContext.getContext().getMetaDataEntry(DefinitionService.getInstance().getPath(this.getDefinitionType(), definitionName));
        if (entry == null) {
            return null;
        }
        D definition = null;
        if (entry.getMetaData() instanceof DefinableMetaData) {
            definition = ((DefinableMetaData)((Object)entry.getMetaData())).currentConfig();
        } else {
            logger.error("metadata is not definable. type=" + entry.getMetaData().getClass().getName());
        }
        return definition;
    }

    @Override
    public DefinitionModifyResult create(D definition) {
        TypedMetaDataService service = this.getService();
        RootMetaData meta = this.newInstance(definition);
        if (!(meta instanceof DefinableMetaData)) {
            logger.error("metadata is not definable. type=" + meta.getClass().getName());
            return new DefinitionModifyResult(false, "metadata is not definable. type=" + meta.getClass().getName());
        }
        ((DefinableMetaData)((Object)meta)).applyConfig(definition);
        try {
            service.createMetaData(meta);
        }
        catch (Exception e) {
            this.setRollbackOnly();
            String type = meta.getClass().getSimpleName();
            if (e.getCause() != null) {
                logger.error("exception occured during " + type + " create:" + e.getCause().getMessage(), e.getCause());
                return new DefinitionModifyResult(false, "exception occured during " + type + " create:" + e.getCause().getMessage());
            }
            logger.error("exception occured during " + type + " create:" + e.getMessage(), (Throwable)e);
            return new DefinitionModifyResult(false, "exception occured during " + type + " create:" + e.getMessage());
        }
        return new DefinitionModifyResult(true);
    }

    @Override
    public DefinitionModifyResult update(D definition) {
        TypedMetaDataService service = this.getService();
        Object handler = this.getService().getRuntimeByName(definition.getName());
        if (handler == null) {
            String type = definition.getClass().getSimpleName();
            logger.error("exception occured during " + type + " update:" + type + " not found.definitionName=" + definition.getName());
            return new DefinitionModifyResult(false, "exception occured during " + type + " update:" + type + " not found.definitionName=" + definition.getName());
        }
        RootMetaData meta = this.newInstance(definition);
        meta.setId(((RootMetaData)handler.getMetaData()).getId());
        if (!(meta instanceof DefinableMetaData)) {
            logger.error("metadata is not definable. type=" + meta.getClass().getName());
            return new DefinitionModifyResult(false, "metadata is not definable. type=" + meta.getClass().getName());
        }
        ((DefinableMetaData)((Object)meta)).applyConfig(definition);
        try {
            service.updateMetaData(meta);
        }
        catch (Exception e) {
            this.setRollbackOnly();
            String type = meta.getClass().getSimpleName();
            if (e.getCause() != null) {
                logger.error("exception occured during " + type + " update:" + e.getCause().getMessage(), e.getCause());
                return new DefinitionModifyResult(false, "exception occured during " + type + " update:" + e.getCause().getMessage());
            }
            logger.error("exception occured during " + type + " update:" + e.getMessage(), (Throwable)e);
            return new DefinitionModifyResult(false, "exception occured during " + type + " update:" + e.getMessage());
        }
        return new DefinitionModifyResult(true);
    }

    @Override
    public DefinitionModifyResult remove(String definitionName) {
        TypedMetaDataService service = this.getService();
        Object handler = service.getRuntimeByName(definitionName);
        if (handler == null) {
            return new DefinitionModifyResult(true);
        }
        RootMetaData meta = (RootMetaData)handler.getMetaData();
        try {
            service.removeMetaData(meta.getName());
        }
        catch (Exception e) {
            this.setRollbackOnly();
            String type = meta.getClass().getSimpleName();
            if (e.getCause() != null) {
                logger.error("exception occured during " + type + " remove:" + e.getCause().getMessage(), e.getCause());
                return new DefinitionModifyResult(false, "exception occured during " + type + " remove:" + e.getCause().getMessage());
            }
            logger.error("exception occured during " + type + " remove:" + e.getMessage(), (Throwable)e);
            return new DefinitionModifyResult(false, "exception occured during " + type + " remove:" + e.getMessage());
        }
        return new DefinitionModifyResult(true);
    }

    protected void setRollbackOnly() {
        Transaction t = Transaction.getCurrent();
        if (t != null && t.getStatus() == TransactionStatus.ACTIVE) {
            t.setRollbackOnly();
        }
    }

    @Override
    public List<DefinitionSummary> definitionSummaryList(String filterPath, boolean recursive) {
        return this.dm.listName(this.getDefinitionType(), filterPath, recursive);
    }

    @Override
    public void rename(String oldDefinitionName, String newDefinitionName) {
        this.dm.rename(this.getDefinitionType(), oldDefinitionName, newDefinitionName);
    }

    protected abstract RootMetaData newInstance(D var1);

    protected abstract TypedMetaDataService getService();
}

