/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.definition;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.iplass.mtp.definition.Definition;
import org.iplass.mtp.definition.TypedDefinitionManager;
import org.iplass.mtp.impl.definition.DefinitionMetaDataTypeMap;
import org.iplass.mtp.impl.definition.DefinitionPath;
import org.iplass.mtp.impl.metadata.RootMetaData;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.iplass.mtp.spi.ServiceRegistry;

public class DefinitionService
implements Service {
    private Map<Class<? extends Definition>, DefinitionMetaDataTypeMap> defMap;
    private Map<Class<? extends RootMetaData>, DefinitionMetaDataTypeMap> metaMap;
    private Map<String, DefinitionMetaDataTypeMap> typeNameMap;
    private MetaDataContextNode<Definition> contextNode;

    public static DefinitionService getInstance() {
        return ServiceRegistry.getRegistry().getService(DefinitionService.class);
    }

    @Override
    public void init(Config config) {
        this.defMap = new HashMap<Class<? extends Definition>, DefinitionMetaDataTypeMap>();
        this.metaMap = new HashMap<Class<? extends RootMetaData>, DefinitionMetaDataTypeMap>();
        this.typeNameMap = new HashMap<String, DefinitionMetaDataTypeMap>();
        this.contextNode = new MetaDataContextNode("root");
        if (config.getNames() != null) {
            for (String typeMapClass : config.getValues("typeMap")) {
                try {
                    DefinitionMetaDataTypeMap typeMap = (DefinitionMetaDataTypeMap)Class.forName(typeMapClass).newInstance();
                    this.defMap.put(typeMap.defType, typeMap);
                    this.metaMap.put(typeMap.metaType, typeMap);
                    this.typeNameMap.put(typeMap.typeName(), typeMap);
                    ((MetaDataContextNode)this.contextNode).addChild(typeMap.pathPrefix, typeMap);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new ServiceConfigrationException("TypeMap:" + typeMapClass + " can't instanceate.");
                }
            }
        }
    }

    @Override
    public void destroy() {
    }

    public Class<? extends Definition> getClassbyTypeName(String typeName) {
        DefinitionMetaDataTypeMap m = this.typeNameMap.get(typeName);
        if (m != null) {
            return m.defType;
        }
        return null;
    }

    public DefinitionPath resolvePath(String path) {
        DefinitionMetaDataTypeMap typeMap = ((MetaDataContextNode)this.contextNode).getTypeMap(path);
        if (typeMap == null) {
            return null;
        }
        return new DefinitionPath(typeMap.defType, path.substring(typeMap.pathPrefix.length()));
    }

    private <D extends Definition> DefinitionMetaDataTypeMap getByDef(Class<D> defType) {
        DefinitionMetaDataTypeMap ret = this.defMap.get(defType);
        if (ret != null) {
            return ret;
        }
        Class<D> superType = defType.getSuperclass();
        while (Definition.class.isAssignableFrom(superType)) {
            ret = this.defMap.get(superType);
            if (ret != null) {
                return ret;
            }
            superType = superType.getSuperclass();
        }
        return null;
    }

    private <M extends RootMetaData> DefinitionMetaDataTypeMap getByMeta(Class<M> metaType) {
        DefinitionMetaDataTypeMap ret = this.metaMap.get(metaType);
        if (ret != null) {
            return ret;
        }
        Class<M> superType = metaType.getSuperclass();
        while (RootMetaData.class.isAssignableFrom(superType)) {
            ret = this.metaMap.get(superType);
            if (ret != null) {
                return ret;
            }
            superType = superType.getSuperclass();
        }
        return null;
    }

    public <D extends Definition> TypedDefinitionManager<D> getTypedDefinitionManager(Class<D> defType) {
        return this.getByDef(defType).typedDefinitionManager();
    }

    public <D extends Definition> String getPrefixPath(Class<D> defType) {
        return this.getByDef(defType).pathPrefix;
    }

    public <D extends Definition> String getPath(Class<D> defType, String defName) {
        if (defName == null) {
            return null;
        }
        DefinitionMetaDataTypeMap td = this.getByDef(defType);
        return td.toPath(defName);
    }

    public <M extends RootMetaData> String getPathByMeta(Class<M> metaType, String defName) {
        if (defName == null) {
            return null;
        }
        DefinitionMetaDataTypeMap td = this.getByMeta(metaType);
        return td.toPath(defName);
    }

    public String getPath(String path) {
        DefinitionMetaDataTypeMap td = ((MetaDataContextNode)this.contextNode).getTypeMap(path);
        String defName = this.getDefinitionName(path);
        return td.toPath(defName);
    }

    public <D extends Definition, M extends RootMetaData> Class<D> getDefinitionType(Class<M> metaType) {
        return this.getByMeta(metaType).defType;
    }

    public <D extends Definition, M extends RootMetaData> D toDefinition(M metaData) {
        return this.getByMeta(metaData.getClass()).toDefinition(metaData);
    }

    public <D extends Definition> String getDefinitionName(Class<D> defType, String path) {
        DefinitionMetaDataTypeMap td = this.getByDef(defType);
        return td.toDefName(path);
    }

    public String getDefinitionName(String path) {
        return this.contextNode.toName(path);
    }

    private static class MetaDataContextNode<D extends Definition> {
        String name;
        DefinitionMetaDataTypeMap<Definition, RootMetaData> typeDef;
        LinkedHashMap<String, MetaDataContextNode<D>> children;

        private MetaDataContextNode(String name) {
            this.name = name;
            this.children = new LinkedHashMap();
        }

        private void addChild(String path, DefinitionMetaDataTypeMap<Definition, RootMetaData> typeDef) {
            String[] nodes;
            MetaDataContextNode<D> child;
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((child = this.children.get((nodes = path.split("/"))[0])) == null) {
                child = new MetaDataContextNode<D>(nodes[0]);
                this.children.put(nodes[0], child);
            }
            if (nodes.length > 1) {
                super.addChild(path.substring(nodes[0].length()), typeDef);
            } else {
                child.typeDef = typeDef;
            }
        }

        private DefinitionMetaDataTypeMap<Definition, RootMetaData> getTypeMap(String path) {
            MetaDataContextNode<D> child;
            int index;
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((index = path.indexOf(47)) > 0 && (child = this.children.get(path.substring(0, index))) != null) {
                return super.getTypeMap(path.substring(index));
            }
            return this.typeDef;
        }

        public String toName(String path) {
            DefinitionMetaDataTypeMap<Definition, RootMetaData> typeMap = this.getTypeMap(path);
            if (typeMap != null) {
                return typeMap.toDefName(path);
            }
            return path;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{name:" + this.name + ", children:[");
            if (this.children.size() > 0) {
                for (MetaDataContextNode<D> child : this.children.values()) {
                    sb.append(child.toString() + ",");
                }
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append("]}");
            return sb.toString();
        }
    }
}

