/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.auditlog;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.DeleteCondition;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.entity.UpdateCondition;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.EntityService;
import org.iplass.mtp.impl.entity.auditlog.AuditLoggingService;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyType;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerAuditLoggingService
implements AuditLoggingService {
    private static Logger logger = LoggerFactory.getLogger((String)"mtp.audit");
    private boolean logCompact;
    private int textMaxLength = 256;
    private boolean logQuery;
    private boolean logSelectValueWithLabel;
    private boolean logReferenceWithLabel;

    public boolean isLogQuery() {
        return this.logQuery;
    }

    public boolean isLogCompact() {
        return this.logCompact;
    }

    public boolean isLogSelectValueWithLabel() {
        return this.logSelectValueWithLabel;
    }

    public boolean isLogReferenceWithLabel() {
        return this.logReferenceWithLabel;
    }

    public int getTextMaxLength() {
        return this.textMaxLength;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void init(Config config) {
        this.logQuery = "TRUE".equalsIgnoreCase(config.getValue("logQuery"));
        this.logCompact = "TRUE".equalsIgnoreCase(config.getValue("logCompact"));
        this.logSelectValueWithLabel = "TRUE".equalsIgnoreCase(config.getValue("logSelectValueWithLabel"));
        this.logReferenceWithLabel = "TRUE".equalsIgnoreCase(config.getValue("logReferenceWithLabel"));
        if (config.getValue("cutSize") != null) {
            this.textMaxLength = Integer.parseInt(config.getValue("textMaxLength"));
        }
    }

    public void log(String action, Object detail) {
        String str = null;
        if (detail != null) {
            str = detail.toString().replace("\n", "\\n").replace("\r", "\\r");
        }
        logger.info(action + "," + str);
    }

    private void cutAppend(StringBuilder sb, Object target) {
        if (target == null) {
            sb.append(target);
        } else {
            String s = target.toString();
            if (this.logCompact) {
                if (s.length() > this.textMaxLength) {
                    s = s.substring(0, this.textMaxLength);
                    sb.append(s);
                    sb.append("...");
                }
            } else {
                sb.append(s);
            }
        }
    }

    private StringBuilder toLogFormat(Entity entity, List<PropertyHandler> logProps) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"definitionName\":\"").append(entity.getDefinitionName()).append("\"");
        sb.append(",\"oid\":\"").append(entity.getOid()).append("\"");
        if (logProps != null) {
            for (PropertyHandler key : logProps) {
                Object val;
                sb.append(",");
                sb.append("\"").append(key.getName()).append("\":");
                PropertyType pt = null;
                if (key instanceof PrimitivePropertyHandler) {
                    pt = ((PrimitivePropertyHandler)key).getMetaData().getType();
                }
                if ((val = entity.getValue(key.getName())) instanceof Object[]) {
                    Object[] valArray = (Object[])val;
                    sb.append("[");
                    for (int i = 0; i < valArray.length; ++i) {
                        if (i != 0) {
                            sb.append(",");
                        }
                        if (valArray[i] instanceof GenericEntity) {
                            sb.append("{\"oid\":\"").append(((GenericEntity)valArray[i]).getOid()).append("\",\"name\":\"");
                            this.cutAppend(sb, ((GenericEntity)valArray[i]).getName());
                            sb.append("\"}");
                            continue;
                        }
                        Object toLogVal = pt != null ? pt.formatToLog(valArray[i]) : valArray[i];
                        if (toLogVal instanceof String) {
                            sb.append("\"");
                            this.cutAppend(sb, toLogVal);
                            sb.append("\"");
                            continue;
                        }
                        sb.append(toLogVal);
                    }
                    sb.append("]");
                    continue;
                }
                if (val instanceof GenericEntity) {
                    sb.append("{\"oid\":\"").append(((GenericEntity)val).getOid()).append("\",\"name\":\"");
                    this.cutAppend(sb, ((GenericEntity)val).getName());
                    sb.append("\"}");
                    continue;
                }
                if (pt != null) {
                    val = pt.formatToLog(val);
                }
                if (val instanceof String) {
                    sb.append("\"");
                    this.cutAppend(sb, val);
                    sb.append("\"");
                    continue;
                }
                sb.append(val);
            }
        }
        sb.append("}");
        return sb;
    }

    @Override
    public void logInsert(Entity entity) {
        EntityHandler eh = ServiceRegistry.getRegistry().getService(EntityService.class).getRuntimeByName(entity.getDefinitionName());
        if (eh != null) {
            this.log("create", this.toLogFormat(entity, eh.getPropertyList(EntityContext.getCurrentContext())));
        }
    }

    @Override
    public void logDelete(Entity entity) {
        String oid = entity.getOid();
        String defName = entity.getDefinitionName();
        StringBuilder sb = new StringBuilder();
        sb.append("{\"definitionName\":\"").append(defName).append("\"");
        sb.append(",\"oid\":\"").append(oid).append("\"}");
        this.log("delete", sb);
    }

    @Override
    public void logDeleteAll(DeleteCondition cond) {
        this.log("deleteAll", cond);
    }

    @Override
    public boolean isLogBeforeEntity(String definitionName) {
        return false;
    }

    @Override
    public void logUpdate(Entity beforeEntity, Entity entity, UpdateOption option) {
        EntityHandler eh = ServiceRegistry.getRegistry().getService(EntityService.class).getRuntimeByName(entity.getDefinitionName());
        if (eh != null) {
            ArrayList<PropertyHandler> props = new ArrayList<PropertyHandler>();
            if (option.getUpdateProperties() != null) {
                EntityContext ec = EntityContext.getCurrentContext();
                for (String up : option.getUpdateProperties()) {
                    if ("updateBy".equals(up)) continue;
                    props.add(eh.getProperty(up, ec));
                }
            }
            StringBuilder sb = this.toLogFormat(entity, props);
            this.log("update", sb);
        }
    }

    @Override
    public void logUpdateAll(UpdateCondition cond) {
        this.log("updateAll", cond);
    }

    @Override
    public void logPurge(Long rbid) {
        this.log("purge", "{\"recycleBinId\":" + rbid + "}");
    }

    @Override
    public void logRestore(String oid, String defName, Long rbid) {
        this.log("restore", "{\"definitionName\":\"" + defName + "\",\"oid\":\"" + oid + "\",\"recycleBinId\":" + rbid + "}");
    }

    @Override
    public void logBulkUpdate(String defName) {
        this.log("bulkUpdate", defName);
    }

    @Override
    public void logQuery(Query query, boolean isCount) {
        if (this.logQuery) {
            if (isCount) {
                this.log("countQuery", query);
            } else {
                this.log("query", query);
            }
        }
    }
}

