/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.cache;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.interceptor.InvocationType;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.util.ObjectUtil;

public class QueryCache
implements Serializable {
    private static final long serialVersionUID = 3525984317258640329L;
    private final Integer count;
    private final List<?> list;
    private final InvocationType listType;
    private final long eol;

    public QueryCache(Integer count, List<?> list, InvocationType listType) {
        this.count = count;
        this.list = list;
        this.listType = listType;
        this.eol = -1L;
    }

    public QueryCache(Integer count, List<?> list, InvocationType listType, int ttl) {
        this.count = count;
        this.list = list;
        this.listType = listType;
        this.eol = ttl > 0 ? System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(ttl) : -1L;
    }

    public Integer getCount() {
        return this.count;
    }

    public List<?> getList() {
        return this.list;
    }

    public InvocationType getListType() {
        return this.listType;
    }

    public long getEol() {
        return this.eol;
    }

    public boolean eol() {
        if (this.eol <= 0L) {
            return false;
        }
        long now = System.currentTimeMillis();
        return now > this.eol;
    }

    public boolean canIterate(InvocationType invocationType) {
        return invocationType == InvocationType.SEARCH_ENTITY ? this.list != null : this.listType == InvocationType.SEARCH;
    }

    public <T> void iterate(Predicate<T> callback, Query query, InvocationType invocationType, EntityHandler eh) {
        block10: {
            block11: {
                block12: {
                    if (invocationType != InvocationType.SEARCH_ENTITY) break block11;
                    if (this.listType != InvocationType.SEARCH_ENTITY) break block12;
                    for (Entity e : this.list) {
                        boolean ret;
                        if (e instanceof GenericEntity) {
                            e = ((GenericEntity)e).deepCopy();
                        } else if (e instanceof Serializable) {
                            e = (Entity)((Object)ObjectUtil.deepCopy((Serializable)((Object)e)));
                        } else {
                            throw new EntityRuntimeException("cant copy from entity query cache:" + e);
                        }
                        if (ret = callback.test(e)) continue;
                        break block10;
                    }
                    break block10;
                }
                if (this.listType != InvocationType.SEARCH) break block10;
                for (Object[] rawData : this.list) {
                    Entity e = eh.newInstance();
                    for (int i = 0; i < query.getSelect().getSelectValues().size(); ++i) {
                        ValueExpression propName = query.getSelect().getSelectValues().get(i);
                        if (!(propName instanceof EntityField)) continue;
                        EntityField ef = (EntityField)propName;
                        e.setValue(ef.getPropertyName(), this.copyVal(rawData[i]));
                    }
                    boolean ret = callback.test(e);
                    if (ret) continue;
                    break block10;
                }
                break block10;
            }
            if (this.listType == InvocationType.SEARCH) {
                for (Object[] rawData : this.list) {
                    Object[] copy = new Object[rawData.length];
                    for (int i = 0; i < rawData.length; ++i) {
                        copy[i] = this.copyVal(rawData[i]);
                    }
                    boolean ret = callback.test((Entity)copy);
                    if (ret) continue;
                    break;
                }
            }
        }
    }

    private Object copyVal(Object val) {
        if (val instanceof Object[]) {
            Object[] valArray = (Object[])val;
            Object[] newValArray = (Object[])Array.newInstance(valArray.getClass().getComponentType(), valArray.length);
            for (int i = 0; i < valArray.length; ++i) {
                newValArray[i] = this.copyVal(valArray[i]);
            }
            return valArray;
        }
        if (val instanceof SelectValue) {
            return ((SelectValue)val).copy();
        }
        if (val instanceof BinaryReference) {
            return ((BinaryReference)val).copy();
        }
        if (val instanceof Date) {
            return ((Date)val).clone();
        }
        return val;
    }
}

