/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.csv;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.zip.ZipOutputStream;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.VersionControlType;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.query.Limit;
import org.iplass.mtp.entity.query.OrderBy;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.QueryVisitorSupport;
import org.iplass.mtp.entity.query.Where;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.impl.entity.csv.EntityCsvWriter;
import org.iplass.mtp.impl.entity.csv.EntityWriteOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySearchCsvWriter
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(EntitySearchCsvWriter.class);
    private final OutputStream out;
    private final String definitionName;
    private final EntityWriteOption option;
    private final ZipOutputStream binaryStore;
    private final EntityManager em;
    private final EntityDefinitionManager edm;
    private EntityCsvWriter writer;

    public EntitySearchCsvWriter(OutputStream out, String definitionName) {
        this(out, definitionName, new EntityWriteOption(), null);
    }

    public EntitySearchCsvWriter(OutputStream out, String definitionName, EntityWriteOption option) {
        this(out, definitionName, option, null);
    }

    public EntitySearchCsvWriter(OutputStream out, String definitionName, EntityWriteOption option, ZipOutputStream binaryStore) {
        this.out = out;
        this.definitionName = definitionName;
        this.option = option;
        this.binaryStore = binaryStore;
        this.em = ManagerLocator.manager(EntityManager.class);
        this.edm = ManagerLocator.manager(EntityDefinitionManager.class);
    }

    public int write() throws IOException {
        EntityDefinition ed = this.edm.get(this.definitionName);
        if (this.writer != null) {
            this.close();
        }
        this.writer = new EntityCsvWriter(ed, this.out, this.option, this.binaryStore);
        boolean hasMultiReference = this.hasMultiReference(this.writer.getProperties());
        Query query = this.createQuery(ed, this.writer.getProperties(), hasMultiReference);
        this.writer.writeHeader();
        return this.searchEntity(this.writer, ed, query, hasMultiReference);
    }

    @Override
    public void close() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    private boolean hasMultiReference(List<PropertyDefinition> properties) {
        return properties.stream().filter(property -> property instanceof ReferenceProperty).anyMatch(property -> property.getMultiplicity() != 1);
    }

    private Query createQuery(EntityDefinition ed, List<PropertyDefinition> properties, boolean hasMultiReference) {
        ArrayList<String> select = new ArrayList<String>();
        if (hasMultiReference) {
            select.add("oid");
            select.add("version");
        } else {
            properties.forEach(property -> {
                String propName = property.getName();
                if (property instanceof ReferenceProperty) {
                    select.add(propName + "." + "oid");
                    select.add(propName + "." + "version");
                } else {
                    select.add(propName);
                }
            });
        }
        Query query = new Query().select(select.toArray(new Object[select.size()])).from(ed.getName());
        query.setWhere(this.option.getWhere());
        query.setOrderBy(this.option.getOrderBy());
        if (ed.getVersionControlType() != VersionControlType.NONE) {
            query.versioned(true);
        } else {
            query.versioned(false);
        }
        if (this.option.getLimit() > 0) {
            query.setLimit(new Limit(this.option.getLimit()));
        }
        return query;
    }

    private int searchEntity(final EntityCsvWriter writer, EntityDefinition ed, Query query, final boolean hasMultiReference) {
        final Query optQuery = this.option.getBeforeSearch().apply(query);
        if (!optQuery.getSelect().isDistinct() && new MultiReferenceChecker(ed).test(optQuery.getWhere())) {
            optQuery.getSelect().setDistinct(true);
            logger.debug("specified distinct for select. because [where conditions] contains multiple reference property. query:" + optQuery);
            if (optQuery.getOrderBy() != null) {
                logger.debug("query [order by] removed. because [where conditions] contains multiple reference property. removed order by:" + optQuery.getOrderBy());
                optQuery.setOrderBy(null);
            }
        }
        if (optQuery.getOrderBy() != null && new MultiReferenceChecker(ed).test(optQuery.getOrderBy())) {
            logger.debug("query [order by] removed. because [order by] contains multiple reference property. removed order by:" + optQuery.getOrderBy());
            optQuery.setOrderBy(null);
        }
        final int[] count = new int[1];
        this.em.searchEntity(optQuery, new Predicate<Entity>(){

            @Override
            public boolean test(Entity entity) {
                if (hasMultiReference) {
                    LoadOption loadOption = new LoadOption();
                    loadOption.setWithMappedByReference(false);
                    entity = EntitySearchCsvWriter.this.em.load(entity.getOid(), entity.getVersion(), entity.getDefinitionName(), loadOption);
                }
                EntitySearchCsvWriter.this.option.getAfterSearch().accept(optQuery.copy(), entity);
                writer.writeEntity(entity);
                count[0] = count[0] + 1;
                return true;
            }
        });
        return count[0];
    }

    private static class MultiReferenceChecker
    extends QueryVisitorSupport {
        private EntityDefinition ed;
        private boolean hasMultiReference;

        public MultiReferenceChecker(EntityDefinition ed) {
            this.ed = ed;
        }

        public boolean test(Where where) {
            this.hasMultiReference = false;
            if (where != null && where.getCondition() != null) {
                where.getCondition().accept(this);
            }
            return this.hasMultiReference;
        }

        public boolean test(OrderBy order) {
            this.hasMultiReference = false;
            if (order != null) {
                order.accept(this);
            }
            return this.hasMultiReference;
        }

        @Override
        public boolean visit(EntityField entityField) {
            PropertyDefinition pd;
            if (entityField.getPropertyName().contains(".") && (pd = this.ed.getProperty(entityField.getPropertyName().substring(0, entityField.getPropertyName().indexOf(".")))) != null && pd instanceof ReferenceProperty) {
                this.hasMultiReference = ((ReferenceProperty)pd).getMultiplicity() != 1;
            }
            return !this.hasMultiReference;
        }
    }
}

