/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.interceptor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.interceptor.EntityInterceptor;
import org.iplass.mtp.entity.interceptor.EntityInvocation;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;

public abstract class EntityInvocationImpl<R>
implements EntityInvocation<R> {
    public static EntityInterceptor[] NULL_ENTITY_INTERCEPTOR = new EntityInterceptor[0];
    private EntityInterceptor[] entityInterceptors;
    private EntityHandler entityHandler;
    private int index;
    private HashMap<String, Object> invocationContextAttributes;

    public EntityInvocationImpl(EntityInterceptor[] entityInterceptors, EntityHandler entityHandler) {
        this.entityInterceptors = entityInterceptors != null ? entityInterceptors : NULL_ENTITY_INTERCEPTOR;
        this.entityHandler = entityHandler;
        this.index = -1;
    }

    protected abstract R callEntityHandler(EntityHandler var1);

    @Override
    public R proceed() {
        ++this.index;
        try {
            if (this.index == this.entityInterceptors.length) {
                R r = this.callEntityHandler(this.entityHandler);
                return r;
            }
            Object object = this.entityInterceptors[this.index].intercept(this);
            return (R)object;
        }
        finally {
            --this.index;
        }
    }

    @Override
    public EntityDefinition getEntityDefinition() {
        return this.entityHandler.getMetaData().currentConfig(EntityContext.getCurrentContext());
    }

    public EntityHandler getEntityHandler() {
        return this.entityHandler;
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.invocationContextAttributes == null) {
            this.invocationContextAttributes = new HashMap();
        }
        this.invocationContextAttributes.put(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        if (this.invocationContextAttributes == null) {
            return null;
        }
        return this.invocationContextAttributes.get(name);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        if (this.invocationContextAttributes == null) {
            List l = Collections.emptyList();
            return l.iterator();
        }
        return this.invocationContextAttributes.keySet().iterator();
    }
}

