/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.l10n;

import java.util.List;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.InsertOption;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.definition.DataLocalizationStrategy;
import org.iplass.mtp.entity.definition.l10n.EachInstanceDataLocalizationStrategy;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.l10n.MetaDataLocalizationStrategy;

public class MetaEachInstanceDataLocalizationStrategy
extends MetaDataLocalizationStrategy {
    private static final long serialVersionUID = -6948763544125469746L;
    private String languagePropertyName;

    public MetaEachInstanceDataLocalizationStrategy() {
    }

    public MetaEachInstanceDataLocalizationStrategy(List<String> languages, String languagePropertyName) {
        super(languages);
        this.languagePropertyName = languagePropertyName;
    }

    public String getLanguagePropertyName() {
        return this.languagePropertyName;
    }

    public void setLanguagePropertyName(String languagePropertyName) {
        this.languagePropertyName = languagePropertyName;
    }

    @Override
    public MetaDataLocalizationStrategy copy() {
        MetaEachInstanceDataLocalizationStrategy copy = new MetaEachInstanceDataLocalizationStrategy();
        this.copyTo(copy);
        copy.languagePropertyName = this.languagePropertyName;
        return copy;
    }

    @Override
    public void applyConfig(DataLocalizationStrategy d) {
        EachInstanceDataLocalizationStrategy def = (EachInstanceDataLocalizationStrategy)d;
        this.fillFrom(def);
        this.languagePropertyName = def.getLanguagePropertyName();
    }

    @Override
    public DataLocalizationStrategy currentConfig() {
        EachInstanceDataLocalizationStrategy def = new EachInstanceDataLocalizationStrategy();
        this.fillTo(def);
        def.setLanguagePropertyName(this.languagePropertyName);
        return def;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.languagePropertyName == null ? 0 : this.languagePropertyName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaEachInstanceDataLocalizationStrategy other = (MetaEachInstanceDataLocalizationStrategy)obj;
        return !(this.languagePropertyName == null ? other.languagePropertyName != null : !this.languagePropertyName.equals(other.languagePropertyName));
    }

    @Override
    public MetaDataLocalizationStrategy.DataLocalizationStrategyRuntime createDataLocalizationStrategyRuntime(EntityHandler eh) {
        return new EachInstanceDataLocalizationStrategyRuntime();
    }

    public class EachInstanceDataLocalizationStrategyRuntime
    extends MetaDataLocalizationStrategy.DataLocalizationStrategyRuntime {
        @Override
        public void handleEntityForInsert(Entity e, InsertOption option) {
            String userLang = ExecuteContext.getCurrentContext().getLanguage();
            if (MetaEachInstanceDataLocalizationStrategy.this.getLanguages() != null && MetaEachInstanceDataLocalizationStrategy.this.getLanguages().contains(userLang)) {
                e.setValue(MetaEachInstanceDataLocalizationStrategy.this.languagePropertyName, userLang);
            } else {
                e.setValue(MetaEachInstanceDataLocalizationStrategy.this.languagePropertyName, null);
            }
        }

        @Override
        public void handleEntityForUpdate(Entity e, UpdateOption option) {
            String userLang = ExecuteContext.getCurrentContext().getLanguage();
            if (MetaEachInstanceDataLocalizationStrategy.this.getLanguages() != null && MetaEachInstanceDataLocalizationStrategy.this.getLanguages().contains(userLang)) {
                e.setValue(MetaEachInstanceDataLocalizationStrategy.this.languagePropertyName, userLang);
            } else {
                e.setValue(MetaEachInstanceDataLocalizationStrategy.this.languagePropertyName, null);
            }
            if (option.getUpdateProperties() == null || !option.getUpdateProperties().contains(MetaEachInstanceDataLocalizationStrategy.this.languagePropertyName)) {
                option.add(MetaEachInstanceDataLocalizationStrategy.this.languagePropertyName);
            }
        }

        @Override
        public Entity handleEntityForLoad(Entity e) {
            return e;
        }
    }
}

