/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityEventContext;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.entity.ValidateResult;
import org.iplass.mtp.entity.interceptor.EntityDeleteInvocation;
import org.iplass.mtp.entity.interceptor.EntityInsertInvocation;
import org.iplass.mtp.entity.interceptor.EntityInterceptorAdapter;
import org.iplass.mtp.entity.interceptor.EntityLoadInvocation;
import org.iplass.mtp.entity.interceptor.EntityPurgeInvocation;
import org.iplass.mtp.entity.interceptor.EntityQueryInvocation;
import org.iplass.mtp.entity.interceptor.EntityRestoreInvocation;
import org.iplass.mtp.entity.interceptor.EntityUpdateInvocation;
import org.iplass.mtp.entity.interceptor.EntityValidateInvocation;
import org.iplass.mtp.entity.interceptor.InvocationType;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.MetaEventListener;
import org.iplass.mtp.impl.entity.interceptor.EntityInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityLoadInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityValidateInvocationImpl;

public class EntityEventListenerInterceptor
extends EntityInterceptorAdapter {
    @Override
    public ValidateResult validate(EntityValidateInvocation invocation) {
        EntityValidateInvocationImpl invImpl = (EntityValidateInvocationImpl)invocation;
        EntityHandler eh = invImpl.getEntityHandler();
        EntityEventContext eeContext = null;
        if (eh.getEventListenerHandlers() != null && eh.getEventListenerHandlers().size() > 0) {
            eeContext = new EntityEventContext();
            if (invocation.getValidatePropertyList() != null) {
                eeContext.setAttribute("validateProperties", new ArrayList<String>(invocation.getValidatePropertyList()));
            }
            if (invImpl.getUpdateOption() != null) {
                eeContext.setAttribute("updateOption", invImpl.getUpdateOption());
            }
            if (invImpl.getInsertOption() != null) {
                eeContext.setAttribute("insertOption", invImpl.getInsertOption());
            }
            for (MetaEventListener.EventListenerRuntime eeh : eh.getEventListenerHandlers()) {
                eeh.handleBeforeValidate(invocation.getEntity(), eeContext);
            }
        }
        return (ValidateResult)invocation.proceed();
    }

    @Override
    public String insert(EntityInsertInvocation invocation) {
        if (invocation.getInsertOption().isNotifyListeners()) {
            EntityHandler eh = ((EntityInvocationImpl)((Object)invocation)).getEntityHandler();
            EntityEventContext eeContext = null;
            if (eh.getEventListenerHandlers() != null && eh.getEventListenerHandlers().size() > 0) {
                eeContext = new EntityEventContext();
                eeContext.setAttribute("insertOption", invocation.getInsertOption());
                for (MetaEventListener.EventListenerRuntime eeh : eh.getEventListenerHandlers()) {
                    if (eeh.handleBeforeInsert(invocation.getEntity(), eeContext)) continue;
                    return null;
                }
            }
            String oid = (String)invocation.proceed();
            if (eeContext != null) {
                for (MetaEventListener.EventListenerRuntime eeh : eh.getEventListenerHandlers()) {
                    eeh.handleAfterInsert(invocation.getEntity(), eeContext);
                }
            }
            return oid;
        }
        return (String)invocation.proceed();
    }

    private boolean loadWithMappedBy(List<MetaEventListener.EventListenerRuntime> elList) {
        for (MetaEventListener.EventListenerRuntime elr : elList) {
            if (elr.getMetaData().isWithoutMappedByReference()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void update(EntityUpdateInvocation invocation) {
        if (invocation.getUpdateOption().isNotifyListeners()) {
            EntityHandler eh = ((EntityInvocationImpl)((Object)invocation)).getEntityHandler();
            EntityEventContext eeContext = null;
            if (eh.getEventListenerHandlers() != null && eh.getEventListenerHandlers().size() > 0) {
                eeContext = new EntityEventContext();
                eeContext.setAttribute("updateOption", invocation.getUpdateOption());
                Entity beforeUpdate = null;
                beforeUpdate = this.loadWithMappedBy(eh.getEventListenerHandlers()) ? (Entity)new EntityLoadInvocationImpl(invocation.getEntity().getOid(), invocation.getEntity().getVersion(), null, false, eh.getService().getInterceptors(), eh).proceed() : (Entity)new EntityLoadInvocationImpl(invocation.getEntity().getOid(), invocation.getEntity().getVersion(), new LoadOption(true, false), false, eh.getService().getInterceptors(), eh).proceed();
                eeContext.setAttribute("beforeUpdateEntity", beforeUpdate);
                for (MetaEventListener.EventListenerRuntime eeh : eh.getEventListenerHandlers()) {
                    if (eeh.handleBeforeUpdate(invocation.getEntity(), eeContext)) continue;
                    return;
                }
            }
            invocation.proceed();
            if (eeContext != null) {
                for (MetaEventListener.EventListenerRuntime eeh : eh.getEventListenerHandlers()) {
                    eeh.handleAfterUpdate(invocation.getEntity(), eeContext);
                }
            }
        } else {
            invocation.proceed();
        }
    }

    @Override
    public void delete(EntityDeleteInvocation invocation) {
        if (invocation.getDeleteOption().isNotifyListeners()) {
            EntityHandler eh = ((EntityInvocationImpl)((Object)invocation)).getEntityHandler();
            EntityEventContext eeContext = null;
            if (eh.getEventListenerHandlers() != null && eh.getEventListenerHandlers().size() > 0) {
                eeContext = new EntityEventContext();
                eeContext.setAttribute("deleteOption", invocation.getDeleteOption());
                for (MetaEventListener.EventListenerRuntime eeh : eh.getEventListenerHandlers()) {
                    if (eeh.handleBeforeDelete(invocation.getEntity(), eeContext)) continue;
                    return;
                }
            }
            invocation.proceed();
            if (eeContext != null) {
                for (MetaEventListener.EventListenerRuntime eeh : eh.getEventListenerHandlers()) {
                    eeh.handleAfterDelete(invocation.getEntity(), eeContext);
                }
                if (invocation.getDeleteOption().isPurge()) {
                    for (MetaEventListener.EventListenerRuntime eeh : eh.getEventListenerHandlers()) {
                        eeh.handleAfterPurge(invocation.getEntity());
                    }
                }
            }
        } else {
            invocation.proceed();
        }
    }

    @Override
    public Entity load(EntityLoadInvocation invocation) {
        EntityHandler eh;
        Entity entity = (Entity)invocation.proceed();
        if (entity != null && (invocation.getLoadOption() == null || invocation.getLoadOption().isNotifyListeners()) && (eh = ((EntityInvocationImpl)((Object)invocation)).getEntityHandler()).getEventListenerHandlers() != null && eh.getEventListenerHandlers().size() > 0) {
            for (MetaEventListener.EventListenerRuntime eeh : eh.getEventListenerHandlers()) {
                eeh.handleOnLoad(entity);
            }
        }
        return entity;
    }

    @Override
    public void query(EntityQueryInvocation invocation) {
        EntityHandler eh;
        if (invocation.getType() == InvocationType.SEARCH_ENTITY && invocation.getSearchOption().isNotifyListeners() && (eh = ((EntityInvocationImpl)((Object)invocation)).getEntityHandler()).getEventListenerHandlers() != null && eh.getEventListenerHandlers().size() > 0) {
            final Predicate<?> actual = invocation.getPredicate();
            Predicate<Entity> wrapper = new Predicate<Entity>(){

                @Override
                public boolean test(Entity entity) {
                    for (MetaEventListener.EventListenerRuntime eeh : eh.getEventListenerHandlers()) {
                        eeh.handleOnLoad(entity);
                    }
                    return actual.test(entity);
                }
            };
            invocation.setPredicate(wrapper);
        }
        invocation.proceed();
    }

    @Override
    public Entity restore(EntityRestoreInvocation invocation) {
        Entity entity = (Entity)invocation.proceed();
        EntityHandler eh = ((EntityInvocationImpl)((Object)invocation)).getEntityHandler();
        if (eh.getEventListenerHandlers() != null && eh.getEventListenerHandlers().size() > 0) {
            for (MetaEventListener.EventListenerRuntime eeh : eh.getEventListenerHandlers()) {
                eeh.handleAfterRestore(entity);
            }
        }
        return entity;
    }

    @Override
    public void purge(EntityPurgeInvocation invocation) {
        EntityHandler eh = ((EntityInvocationImpl)((Object)invocation)).getEntityHandler();
        GenericEntity entity = null;
        if (eh.getEventListenerHandlers() != null && eh.getEventListenerHandlers().size() > 0) {
            final GenericEntity ee = new GenericEntity();
            eh.getRecycleBin(new Predicate<Entity>(){

                @Override
                public boolean test(Entity dataModel) {
                    ee.setOid(dataModel.getOid());
                    ee.setName(dataModel.getName());
                    ee.setRecycleBinId(dataModel.getRecycleBinId());
                    ee.setUpdateDate(dataModel.getUpdateDate());
                    ee.setUpdateBy(dataModel.getUpdateBy());
                    return false;
                }
            }, invocation.getRecycleBinId());
            entity = ee;
        }
        invocation.proceed();
        if (eh.getEventListenerHandlers() != null && eh.getEventListenerHandlers().size() > 0) {
            for (MetaEventListener.EventListenerRuntime eeh : eh.getEventListenerHandlers()) {
                eeh.handleAfterPurge(entity);
            }
        }
    }
}

