/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.property;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.ValidationDefinition;
import org.iplass.mtp.impl.datastore.MetaPropertyStore;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaPrimitiveProperty;
import org.iplass.mtp.impl.entity.property.MetaReferenceProperty;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.validation.MetaValidation;
import org.iplass.mtp.impl.validation.ValidationService;
import org.iplass.mtp.spi.ServiceRegistry;

@XmlSeeAlso(value={MetaPrimitiveProperty.class, MetaReferenceProperty.class})
public abstract class MetaProperty
implements MetaData {
    private static final long serialVersionUID = 2022181816499023008L;
    private String id;
    private String name;
    private String displayName;
    private String description;
    private String defaultValue;
    private boolean updatable = true;
    private int multiplicity = 1;
    private List<MetaValidation> validations = new ArrayList<MetaValidation>();
    private List<MetaLocalizedString> localizedDisplayNameList = new ArrayList<MetaLocalizedString>();
    private IndexType indexType;
    private MetaPropertyStore entityStoreProperty;

    public MetaPropertyStore getEntityStoreProperty() {
        return this.entityStoreProperty;
    }

    public void setEntityStoreProperty(MetaPropertyStore entityStoreProperty) {
        this.entityStoreProperty = entityStoreProperty;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getMultiplicity() {
        return this.multiplicity;
    }

    public void setMultiplicity(int multiplicity) {
        this.multiplicity = multiplicity;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public void setIndexType(IndexType indexType) {
        this.indexType = indexType;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public List<MetaValidation> getValidations() {
        return this.validations;
    }

    public void setValidations(List<MetaValidation> validations) {
        if (validations == null) {
            new Exception("call setValidations to null").printStackTrace();
        }
        if (validations != null && validations.size() == 0) {
            new Exception("call setValidations").printStackTrace();
        }
        this.validations = validations;
    }

    public List<MetaLocalizedString> getLocalizedDisplayNameList() {
        return this.localizedDisplayNameList;
    }

    public void setLocalizedDisplayNameList(List<MetaLocalizedString> localizedDisplayNameList) {
        this.localizedDisplayNameList = localizedDisplayNameList;
    }

    public abstract void applyConfig(PropertyDefinition var1, EntityContext var2);

    protected void fillFrom(PropertyDefinition pDef, EntityContext context) {
        this.name = pDef.getName();
        this.displayName = pDef.getDisplayName() != null && !pDef.getDisplayName().equals(pDef.getName()) ? pDef.getDisplayName() : null;
        this.multiplicity = pDef.getMultiplicity();
        this.description = pDef.getDescription();
        this.defaultValue = pDef.getDefaultValue();
        this.updatable = pDef.isUpdatable();
        this.indexType = pDef.getIndexType();
        ValidationService vService = ServiceRegistry.getRegistry().getService(ValidationService.class);
        this.validations = new ArrayList<MetaValidation>();
        if (pDef.getValidations() != null) {
            for (ValidationDefinition v : pDef.getValidations()) {
                this.validations.add(vService.createValidationMetaData(v));
            }
        }
        this.localizedDisplayNameList = I18nUtil.toMeta(pDef.getLocalizedDisplayNameList());
    }

    public abstract PropertyDefinition currentConfig(EntityContext var1);

    protected void fillTo(PropertyDefinition pd, EntityContext context) {
        pd.setName(this.name);
        if (this.displayName != null) {
            pd.setDisplayName(this.displayName);
        } else {
            pd.setDisplayName(this.name);
        }
        pd.setIndexType(this.indexType);
        pd.setMultiplicity(this.multiplicity);
        pd.setDescription(this.description);
        pd.setDefaultValue(this.defaultValue);
        pd.setUpdatable(this.updatable);
        ArrayList<ValidationDefinition> valis = new ArrayList<ValidationDefinition>();
        if (this.validations != null) {
            for (MetaValidation v : this.validations) {
                valis.add(v.currentConfig(context));
            }
        }
        pd.setValidations(valis);
        pd.setLocalizedDisplayNameList(I18nUtil.toDef(this.localizedDisplayNameList));
    }

    @Override
    public abstract MetaProperty copy();

    public abstract PropertyHandler createRuntime(MetaEntity var1);

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.entityStoreProperty == null ? 0 : this.entityStoreProperty.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.indexType == null ? 0 : this.indexType.hashCode());
        result = 31 * result + (this.localizedDisplayNameList == null ? 0 : this.localizedDisplayNameList.hashCode());
        result = 31 * result + this.multiplicity;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.updatable ? 1231 : 1237);
        result = 31 * result + (this.validations == null ? 0 : this.validations.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaProperty other = (MetaProperty)obj;
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.entityStoreProperty == null ? other.entityStoreProperty != null : !this.entityStoreProperty.equals(other.entityStoreProperty)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.indexType != other.indexType) {
            return false;
        }
        if (this.localizedDisplayNameList == null ? other.localizedDisplayNameList != null : !this.localizedDisplayNameList.equals(other.localizedDisplayNameList)) {
            return false;
        }
        if (this.multiplicity != other.multiplicity) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.updatable != other.updatable) {
            return false;
        }
        return !(this.validations == null ? other.validations != null : !this.validations.equals(other.validations));
    }
}

