/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.property;

import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.query.PreparedQuery;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaReferenceProperty;
import org.iplass.mtp.impl.entity.property.PropertyHandler;

public class ReferencePropertyHandler
extends PropertyHandler {
    private PreparedQuery asOfExpression;

    public ReferencePropertyHandler(MetaReferenceProperty meta, MetaEntity metaEntity) {
        super(meta, metaEntity);
        if (meta.getVersionControlAsOfExpression() != null) {
            this.asOfExpression = new PreparedQuery(meta.getVersionControlAsOfExpression());
        }
    }

    public EntityHandler getReferenceEntityHandler(EntityContext ctx) {
        return ctx.getHandlerById(((MetaReferenceProperty)this.metaData).getReferenceEntityMetaDataId());
    }

    public ValueExpression getAsOfExpression() {
        if (this.asOfExpression == null) {
            return null;
        }
        return this.asOfExpression.value(null);
    }

    public ReferencePropertyHandler getMappedByPropertyHandler(EntityContext ctx) {
        MetaReferenceProperty meta = (MetaReferenceProperty)this.metaData;
        if (meta.getMappedByPropertyMetaDataId() == null) {
            return null;
        }
        EntityHandler mappedByEntity = ctx.getHandlerById(meta.getReferenceEntityMetaDataId());
        if (mappedByEntity == null) {
            return null;
        }
        for (PropertyHandler ph : mappedByEntity.getDeclaredPropertyList()) {
            if (!(ph instanceof ReferencePropertyHandler) || !ph.getId().equals(meta.getMappedByPropertyMetaDataId())) continue;
            return (ReferencePropertyHandler)ph;
        }
        return null;
    }

    public ReferencePropertyHandler getMappedByPropertyHandlerFromMain(EntityContext ctx) {
        MetaReferenceProperty meta = (MetaReferenceProperty)this.metaData;
        EntityHandler mappedByEntity = ctx.getHandlerById(meta.getReferenceEntityMetaDataId());
        if (mappedByEntity == null) {
            return null;
        }
        for (PropertyHandler ph : mappedByEntity.getDeclaredPropertyList()) {
            if (!(ph instanceof ReferencePropertyHandler) || !this.getId().equals(((ReferencePropertyHandler)ph).getMetaData().getMappedByPropertyMetaDataId())) continue;
            return (ReferencePropertyHandler)ph;
        }
        return null;
    }

    @Override
    public MetaReferenceProperty getMetaData() {
        return (MetaReferenceProperty)this.metaData;
    }

    @Override
    public PropertyDefinitionType getEnumType() {
        return PropertyDefinitionType.REFERENCE;
    }

    @Override
    public Object[] newArrayInstance(int size, EntityContext ec) {
        return this.getReferenceEntityHandler(ec).newArrayInstance(size);
    }
}

