/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.fulltextsearch;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.iplass.mtp.impl.fulltextsearch.AnalyzerSetting;
import org.iplass.mtp.impl.fulltextsearch.JapaneseAnalyzerSetting;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzerFactory {
    private static Logger logger = LoggerFactory.getLogger(AnalyzerFactory.class);

    public static Analyzer createAnalyzer(String className, AnalyzerSetting analyzerSetting) throws ClassNotFoundException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        if (analyzerSetting != null && JapaneseAnalyzer.class.isAssignableFrom(Class.forName(className))) {
            JapaneseAnalyzerSetting japaneseAnalyzerSetting = (JapaneseAnalyzerSetting)analyzerSetting;
            UserDictionary userDict = AnalyzerFactoryJapaneseAnalyzer.createUserDictionary(japaneseAnalyzerSetting.getUserDictionary());
            JapaneseTokenizer.Mode mode = AnalyzerFactoryJapaneseAnalyzer.createMode(japaneseAnalyzerSetting.getMode());
            CharArraySet stopwords = AnalyzerFactoryJapaneseAnalyzer.createStopwords(japaneseAnalyzerSetting.getStopwords());
            Set<String> stoptags = AnalyzerFactoryJapaneseAnalyzer.createStopTags(japaneseAnalyzerSetting.getStoptags());
            try {
                Constructor<?> c = Class.forName(className).getConstructor(UserDictionary.class, JapaneseTokenizer.Mode.class, CharArraySet.class, Set.class);
                return (Analyzer)c.newInstance(userDict, mode, stopwords, stoptags);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return (Analyzer)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private static abstract class AnalyzerFactoryJapaneseAnalyzer
    extends StopwordAnalyzerBase {
        private AnalyzerFactoryJapaneseAnalyzer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static UserDictionary createUserDictionary(String userDictionary) {
            if (StringUtil.isEmpty(userDictionary)) {
                return null;
            }
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader(AnalyzerFactoryJapaneseAnalyzer.class.getResourceAsStream(userDictionary), Charset.forName("utf-8"));
                UserDictionary userDictionary2 = UserDictionary.open((Reader)reader);
                return userDictionary2;
            }
            catch (IOException e) {
                logger.warn("User Dictionary not found. : " + userDictionary);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    logger.warn("Error occured when close the reader of user dictionary. :" + userDictionary);
                }
            }
            return null;
        }

        public static JapaneseTokenizer.Mode createMode(String mode) {
            try {
                if (StringUtil.isEmpty(mode)) {
                    return JapaneseTokenizer.Mode.SEARCH;
                }
                return JapaneseTokenizer.Mode.valueOf((String)mode);
            }
            catch (IllegalArgumentException e) {
                return JapaneseTokenizer.Mode.SEARCH;
            }
        }

        public static CharArraySet createStopwords(String stopwords) {
            if (StringUtil.isEmpty(stopwords)) {
                return JapaneseAnalyzer.getDefaultStopSet();
            }
            try {
                return StopwordAnalyzerBase.loadStopwordSet((boolean)true, AnalyzerFactoryJapaneseAnalyzer.class, (String)stopwords, (String)"#");
            }
            catch (IOException e) {
                logger.warn("Unable to load stopword set : " + stopwords + ",  So use default one.");
                return JapaneseAnalyzer.getDefaultStopSet();
            }
        }

        public static Set<String> createStopTags(String stoptags) {
            if (StringUtil.isEmpty(stoptags)) {
                return JapaneseAnalyzer.getDefaultStopTags();
            }
            try {
                CharArraySet tagset = StopwordAnalyzerBase.loadStopwordSet((boolean)false, AnalyzerFactoryJapaneseAnalyzer.class, (String)stoptags, (String)"#");
                HashSet<String> tags = new HashSet<String>();
                for (Object element : tagset) {
                    char[] chars = (char[])element;
                    tags.add(new String(chars));
                }
                return tags;
            }
            catch (IOException e) {
                logger.warn("Unable to load stoptag set : " + stoptags + ", So use default one.");
                return JapaneseAnalyzer.getDefaultStopTags();
            }
        }
    }
}

