/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.lob.lobstore.rdb;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.iplass.mtp.impl.lob.lobstore.LobData;
import org.iplass.mtp.impl.lob.lobstore.LobStoreRuntimeException;
import org.iplass.mtp.impl.lob.sql.LobStoreSearchSql;
import org.iplass.mtp.impl.lob.sql.LobStoreUpdateSql;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbLobData
implements LobData {
    private static Logger logger = LoggerFactory.getLogger(RdbLobData.class);
    private int tenantId;
    private long lobDataId;
    private boolean manageLobSizeOnRdb;
    private RdbAdapter rdb;
    private long sizeCache = -1L;

    public RdbLobData(int tenantId, long lobDataId, boolean manageLobSizeOnRdb, RdbAdapter rdb) {
        this.tenantId = tenantId;
        this.lobDataId = lobDataId;
        this.manageLobSizeOnRdb = manageLobSizeOnRdb;
        this.rdb = rdb;
    }

    @Override
    public long getLobDataId() {
        return this.lobDataId;
    }

    @Override
    public long getSize() {
        if (this.sizeCache == -1L) {
            SqlExecuter<Long> exec = new SqlExecuter<Long>(){

                /*
                 * Exception decompiling
                 */
                @Override
                public Long logic() throws SQLException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            };
            this.sizeCache = (Long)exec.execute(this.rdb, true);
        }
        return this.sizeCache;
    }

    @Override
    public boolean exists() {
        if (this.sizeCache == -1L) {
            this.getSize();
        }
        return this.sizeCache > 0L;
    }

    @Override
    public InputStream getBinaryInputStream() {
        return new LobInputStream();
    }

    @Override
    public OutputStream getBinaryOutputStream() {
        return new LobOutputStream();
    }

    @Override
    public void transferFrom(File file) throws IOException {
        byte[] buf = new byte[8192];
        try (FileInputStream is = new FileInputStream(file);
             OutputStream os = this.getBinaryOutputStream();){
            int count;
            while ((count = ((InputStream)is).read(buf)) != -1) {
                os.write(buf, 0, count);
            }
            os.flush();
        }
    }

    private class LobOutputStreamSqlExecuter
    extends SqlExecuter<Boolean> {
        boolean doInit = true;
        Blob blob;
        OutputStream os;

        LobOutputStreamSqlExecuter() {
        }

        @Override
        public Boolean logic() throws SQLException {
            if (this.doInit) {
                return this.initBlob();
            }
            return this.storeBlob();
        }

        private Boolean initBlob() throws SQLException {
            if (RdbLobData.this.rdb.isSupportBlobType()) {
                this.blob = this.getConnection().createBlob();
                this.os = this.blob.setBinaryStream(1L);
            } else {
                this.os = new ByteArrayOutputStream();
            }
            return Boolean.TRUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Boolean storeBlob() throws SQLException {
            InputStream is = null;
            try {
                LobStoreUpdateSql sql = RdbLobData.this.rdb.getUpdateSqlCreator(LobStoreUpdateSql.class);
                PreparedStatement stmt = this.getPreparedStatement(sql.toPrepareSqlForLobUpdate(RdbLobData.this.manageLobSizeOnRdb, RdbLobData.this.rdb));
                int i = 1;
                if (RdbLobData.this.rdb.isSupportBlobType()) {
                    stmt.setBlob(i++, this.blob);
                    if (RdbLobData.this.manageLobSizeOnRdb) {
                        stmt.setLong(i++, this.blob.length());
                    }
                } else {
                    stmt.setBytes(i++, ((ByteArrayOutputStream)this.os).toByteArray());
                }
                stmt.setInt(i++, RdbLobData.this.tenantId);
                stmt.setLong(i++, RdbLobData.this.lobDataId);
                if (stmt.executeUpdate() != 1) {
                    throw new LobStoreRuntimeException("Concurrent Update Occured.");
                }
                if (this.blob != null) {
                    this.blob.free();
                }
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        logger.warn("can not close inputstream resource:" + is, (Throwable)e);
                    }
                }
            }
        }
    }

    private class LobOutputStream
    extends OutputStream {
        private LobOutputStreamSqlExecuter exec;

        LobOutputStream() {
            this.exec = new LobOutputStreamSqlExecuter();
            this.exec.doInit = true;
            if (!((Boolean)this.exec.execute(RdbLobData.this.rdb, false)).booleanValue()) {
                throw new LobStoreRuntimeException("Concurrent Update Occured.");
            }
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.exec != null && this.exec.os != null) {
                    this.exec.os.flush();
                    this.exec.os.close();
                }
            }
            finally {
                if (this.exec != null) {
                    this.exec.doInit = false;
                    this.exec.execute(RdbLobData.this.rdb, true);
                }
                this.exec = null;
                RdbLobData.this.sizeCache = -1L;
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.exec.os != null) {
                this.exec.os.flush();
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.exec == null) {
                throw new IOException("already closed.");
            }
            this.exec.os.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (this.exec == null) {
                throw new IOException("already closed.");
            }
            this.exec.os.write(b);
        }

        @Override
        public void write(int b) throws IOException {
            if (this.exec == null) {
                throw new IOException("already closed.");
            }
            this.exec.os.write(b);
        }
    }

    private class LobInputStream
    extends InputStream {
        private SqlExecuter<InputStream> exec;
        private ResultSet rs;
        private Blob blob;
        private InputStream wrapped;
        private boolean closed;

        LobInputStream() {
            this.exec = new SqlExecuter<InputStream>(){

                @Override
                public InputStream logic() throws SQLException {
                    LobStoreSearchSql sql = RdbLobData.this.rdb.getQuerySqlCreator(LobStoreSearchSql.class);
                    LobInputStream.this.rs = this.getStatement().executeQuery(sql.toSql(RdbLobData.this.tenantId, RdbLobData.this.lobDataId, RdbLobData.this.rdb));
                    if (RdbLobData.this.rdb.isSupportBlobType()) {
                        LobInputStream.this.blob = sql.getBlob(LobInputStream.this.rs, RdbLobData.this.rdb);
                        if (LobInputStream.this.blob == null) {
                            RdbLobData.this.sizeCache = 0L;
                            return null;
                        }
                        InputStream is = LobInputStream.this.blob.getBinaryStream();
                        RdbLobData.this.sizeCache = LobInputStream.this.blob.length();
                        return is;
                    }
                    InputStream is = sql.getBinaryStream(LobInputStream.this.rs, RdbLobData.this.rdb);
                    if (is == null) {
                        RdbLobData.this.sizeCache = 0L;
                        return null;
                    }
                    try {
                        RdbLobData.this.sizeCache = is.available();
                    }
                    catch (IOException e) {
                        try {
                            is.close();
                        }
                        catch (IOException e1) {
                            e.addSuppressed(e1);
                        }
                        throw new LobStoreRuntimeException(e);
                    }
                    return is;
                }
            };
            this.wrapped = this.exec.execute(RdbLobData.this.rdb, false);
        }

        @Override
        public int available() throws IOException {
            if (this.wrapped == null) {
                return 0;
            }
            return this.wrapped.available();
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                try {
                    try {
                        if (this.wrapped != null) {
                            this.wrapped.close();
                        }
                        if (this.blob != null) {
                            this.blob.free();
                        }
                    }
                    finally {
                        if (this.rs != null) {
                            this.rs.close();
                        }
                    }
                }
                catch (SQLException se) {
                    throw new IOException(se);
                }
                finally {
                    if (this.exec != null) {
                        this.exec.close();
                    }
                }
                this.closed = true;
            }
        }

        @Override
        public synchronized void mark(int readlimit) {
            if (this.wrapped != null) {
                this.wrapped.mark(readlimit);
            }
        }

        @Override
        public boolean markSupported() {
            if (this.wrapped == null) {
                return false;
            }
            return this.wrapped.markSupported();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.wrapped == null) {
                return -1;
            }
            return this.wrapped.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (this.wrapped == null) {
                return -1;
            }
            return this.wrapped.read(b);
        }

        @Override
        public synchronized void reset() throws IOException {
            if (this.wrapped != null) {
                this.wrapped.reset();
            }
        }

        @Override
        public long skip(long n) throws IOException {
            if (this.wrapped == null) {
                return 0L;
            }
            return this.wrapped.skip(n);
        }

        @Override
        public int read() throws IOException {
            if (this.wrapped == null) {
                return -1;
            }
            return this.wrapped.read();
        }
    }
}

