/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.lob.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.iplass.mtp.impl.lob.Lob;
import org.iplass.mtp.impl.lob.LobDao;
import org.iplass.mtp.impl.lob.lobstore.LobStore;
import org.iplass.mtp.impl.rdb.adapter.QuerySqlHandler;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;

public class BlobSearchSql
extends QuerySqlHandler {
    public String toSql(RdbAdapter rdb, int tenantId, long lobId, String sessionId, String defId, String propId, String oid, Long version, boolean withLock) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT TENANT_ID,LOB_ID,LOB_NAME,LOB_TYPE,LOB_STAT,LOB_DATA_ID,SESS_ID,OBJ_DEF_ID,PROP_DEF_ID,OBJ_ID,OBJ_VER FROM OBJ_BLOB WHERE TENANT_ID=");
        sb.append(tenantId);
        sb.append(" AND LOB_ID=");
        sb.append(lobId);
        if (sessionId != null) {
            sb.append(" AND SESS_ID=");
            sb.append("'").append(rdb.sanitize(sessionId)).append("'");
        }
        if (defId != null) {
            sb.append(" AND OBJ_DEF_ID=");
            sb.append("'").append(rdb.sanitize(defId)).append("'");
        }
        if (propId != null) {
            sb.append(" AND PROP_DEF_ID=");
            sb.append("'").append(rdb.sanitize(propId)).append("'");
        }
        if (oid != null) {
            sb.append(" AND OBJ_ID=");
            sb.append("'").append(rdb.sanitize(oid)).append("'");
        }
        if (version != null) {
            sb.append(" AND OBJ_VER=");
            sb.append(version);
        }
        return withLock ? rdb.createRowLockSql(sb.toString()) : sb.toString();
    }

    public String toSearchSql(RdbAdapter rdb, int tenantId, long[] lobId) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT TENANT_ID,LOB_ID,LOB_NAME,LOB_TYPE,LOB_STAT,LOB_DATA_ID,SESS_ID,OBJ_DEF_ID,PROP_DEF_ID,OBJ_ID,OBJ_VER FROM OBJ_BLOB WHERE TENANT_ID=");
        sb.append(tenantId);
        sb.append(" AND LOB_ID IN (");
        for (int i = 0; i < lobId.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(lobId[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    public String toSqlByDefId(RdbAdapter rdb, int tenantId, String defId) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT TENANT_ID,LOB_ID,LOB_DATA_ID,OBJ_DEF_ID FROM OBJ_BLOB WHERE TENANT_ID=");
        sb.append(tenantId);
        sb.append(" AND OBJ_DEF_ID=");
        sb.append("'").append(rdb.sanitize(defId)).append("'");
        return sb.toString();
    }

    public String toSqlForCleanTemporary(RdbAdapter rdb, int day, int tenantId) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT TENANT_ID,LOB_ID,LOB_NAME,LOB_TYPE,LOB_STAT,LOB_DATA_ID,SESS_ID,OBJ_DEF_ID,PROP_DEF_ID,OBJ_ID,OBJ_VER FROM OBJ_BLOB");
        sb.append(" WHERE LOB_STAT='T'");
        sb.append(" AND TENANT_ID=");
        sb.append(tenantId);
        sb.append(" AND UP_DATE<").append(rdb.addDate(rdb.systimestamp(), day));
        return sb.toString();
    }

    public Lob toBinaryData(ResultSet rs, LobStore lobStore, LobDao dao, boolean manageLobSizeOnRdb) throws SQLException {
        return new Lob(rs.getInt("TENANT_ID"), rs.getLong("LOB_ID"), rs.getString("LOB_NAME"), rs.getString("LOB_TYPE"), rs.getString("OBJ_DEF_ID"), rs.getString("PROP_DEF_ID"), rs.getString("OBJ_ID"), rs.getLong("OBJ_VER"), rs.getString("SESS_ID"), rs.getString("LOB_STAT"), rs.getLong("LOB_DATA_ID"), lobStore, dao, manageLobSizeOnRdb);
    }

    public String toSqlForDefrag(RdbAdapter rdb, int tenantId, String defId, List<String> validPropertyIds) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT TENANT_ID,LOB_ID,LOB_DATA_ID,OBJ_DEF_ID,PROP_DEF_ID FROM OBJ_BLOB WHERE TENANT_ID=");
        sb.append(tenantId);
        sb.append(" AND OBJ_DEF_ID=");
        sb.append("'").append(rdb.sanitize(defId)).append("'");
        if (!validPropertyIds.isEmpty()) {
            StringBuilder notin = new StringBuilder();
            for (String propertyId : validPropertyIds) {
                notin.append("'" + rdb.sanitize(propertyId) + "',");
            }
            notin.deleteCharAt(notin.length() - 1);
            sb.append(" AND PROP_DEF_ID NOT IN (").append(notin.toString()).append(")");
        }
        return sb.toString();
    }

    public String toSqlForMigrate(RdbAdapter rdb, int tenantId) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT TENANT_ID,LOB_ID,LOB_NAME,LOB_TYPE,LOB_STAT,LOB_DATA_ID,SESS_ID,OBJ_DEF_ID,PROP_DEF_ID,OBJ_ID,OBJ_VER FROM OBJ_BLOB WHERE TENANT_ID=");
        sb.append(tenantId);
        return sb.toString();
    }
}

