/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.mail;

import java.util.Map;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.mail.MailService;
import org.iplass.mtp.impl.mail.template.MetaMailTemplate;
import org.iplass.mtp.mail.Mail;
import org.iplass.mtp.mail.MailManager;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;

public class MailManagerImpl
implements MailManager {
    private MailService mailService = ServiceRegistry.getRegistry().getService(MailService.class);

    @Override
    public Mail createMail() {
        return this.mailService.createMail(ExecuteContext.getCurrentContext().getCurrentTenant(), null);
    }

    @Override
    public void sendMail(Mail mail) {
        Tenant tenant = ExecuteContext.getCurrentContext().getCurrentTenant();
        this.mailService.sendMail(tenant, mail);
    }

    @Override
    public Mail createMail(String tmplDefName, Map<String, Object> bindings) {
        MetaMailTemplate.MailTemplateRuntime tmpl = (MetaMailTemplate.MailTemplateRuntime)this.mailService.getRuntimeByName(tmplDefName);
        if (tmpl == null) {
            throw new SystemException("mailTemplate:" + tmplDefName + " not found");
        }
        return tmpl.createMail(bindings);
    }
}

