/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.mail;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.definition.TypedDefinitionManager;
import org.iplass.mtp.impl.definition.AbstractTypedMetaDataService;
import org.iplass.mtp.impl.definition.DefinitionMetaDataTypeMap;
import org.iplass.mtp.impl.mail.MailService;
import org.iplass.mtp.impl.mail.template.MetaMailTemplate;
import org.iplass.mtp.mail.Mail;
import org.iplass.mtp.mail.MailException;
import org.iplass.mtp.mail.SendMailListener;
import org.iplass.mtp.mail.template.definition.MailTemplateDefinition;
import org.iplass.mtp.mail.template.definition.MailTemplateDefinitionManager;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tenant.TenantMailInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailServiceImpl
extends AbstractTypedMetaDataService<MetaMailTemplate, MetaMailTemplate.MailTemplateRuntime>
implements MailService {
    public static final String MAIL_TEMPLATE_META_PATH = "/mail/template/";
    public static final String ISO_2022_JP = "ISO-2022-JP";
    public static final String ENCODING_7BIT = "7bit";
    public static final String DEFAULT_TIMEOUT_MILLIS = "60000";
    public static final String MAIL_SMTP_POPBEFORESMTP = "mail.smtp.popbeforesmtp";
    public static final String MAIL_POP3_AUTH_ID = "mail.pop3.auth.id";
    public static final String MAIL_POP3_AUTH_PASSWORD = "mail.pop3.auth.password";
    public static final String MAIL_SMTP_AUTH_ID = "mail.smtp.auth.id";
    public static final String MAIL_SMTP_AUTH_PASSWORD = "mail.smtp.auth.password";
    public static final String MAIL_CHARSET = "mail.charset";
    public static final String MAIL_ENCODING = "mail.encoding";
    private static Logger logger = LoggerFactory.getLogger(MailServiceImpl.class);
    private boolean debug;
    private boolean mailSmtpPopbeforesmtp;
    private boolean mailSmtpAuth;
    private String mailPop3AuthId;
    private String mailPop3AuthPassword;
    private String mailSmtpAuthId;
    private String mailSmtpAuthPassword;
    private String mailCharset;
    private String mailEncoding;
    private Map<String, Object> sendProperties;
    private List<SendMailListener> listener;
    private long retryIntervalMillis;
    private int retryCount;

    public Map<String, Object> getSendProperties() {
        return this.sendProperties;
    }

    public static String getFixedPath() {
        return MAIL_TEMPLATE_META_PATH;
    }

    public long getRetryIntervalMillis() {
        return this.retryIntervalMillis;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public List<SendMailListener> getListener() {
        return this.listener;
    }

    @Override
    public void init(Config config) {
        this.listener = config.getValues("listener", SendMailListener.class);
        this.retryIntervalMillis = config.getValue("retryIntervalMillis", Long.TYPE, 0L);
        this.retryCount = config.getValue("retryCount", Integer.TYPE, 0);
        this.debug = config.getValue("debug", Boolean.TYPE, false);
        this.sendProperties = new HashMap<String, Object>();
        Iterator<String> iterator = config.getNames().iterator();
        block18: while (iterator.hasNext()) {
            String name;
            switch (name = iterator.next()) {
                case "mail.smtp.popbeforesmtp": {
                    this.mailSmtpPopbeforesmtp = config.getValue(MAIL_SMTP_POPBEFORESMTP, Boolean.TYPE, false);
                    continue block18;
                }
                case "mail.pop3.auth.id": {
                    this.mailPop3AuthId = config.getValue(MAIL_POP3_AUTH_ID);
                    continue block18;
                }
                case "mail.pop3.auth.password": {
                    this.mailPop3AuthPassword = config.getValue(MAIL_POP3_AUTH_PASSWORD);
                    continue block18;
                }
                case "mail.smtp.auth.id": {
                    this.mailSmtpAuthId = config.getValue(MAIL_SMTP_AUTH_ID);
                    continue block18;
                }
                case "mail.smtp.auth.password": {
                    this.mailSmtpAuthPassword = config.getValue(MAIL_SMTP_AUTH_PASSWORD);
                    continue block18;
                }
                case "mail.charset": {
                    this.mailCharset = config.getValue(MAIL_CHARSET);
                    continue block18;
                }
                case "mail.encoding": {
                    this.mailEncoding = config.getValue(MAIL_ENCODING);
                    continue block18;
                }
            }
            if (!name.startsWith("mail.")) continue;
            this.sendProperties.put(name, config.getValue(name));
        }
        if (!this.sendProperties.containsKey("mail.smtp.connectiontimeout")) {
            this.sendProperties.put("mail.smtp.connectiontimeout", DEFAULT_TIMEOUT_MILLIS);
        }
        if (!this.sendProperties.containsKey("mail.smtp.timeout")) {
            this.sendProperties.put("mail.smtp.timeout", DEFAULT_TIMEOUT_MILLIS);
        }
        if (!this.sendProperties.containsKey("mail.smtps.connectiontimeout")) {
            this.sendProperties.put("mail.smtps.connectiontimeout", DEFAULT_TIMEOUT_MILLIS);
        }
        if (!this.sendProperties.containsKey("mail.smtps.timeout")) {
            this.sendProperties.put("mail.smtps.timeout", DEFAULT_TIMEOUT_MILLIS);
        }
        if (!this.sendProperties.containsKey("mail.pop3.connectiontimeout")) {
            this.sendProperties.put("mail.pop3.connectiontimeout", DEFAULT_TIMEOUT_MILLIS);
        }
        if (!this.sendProperties.containsKey("mail.pop3.timeout")) {
            this.sendProperties.put("mail.pop3.timeout", DEFAULT_TIMEOUT_MILLIS);
        }
        this.mailSmtpAuth = "TRUE".equalsIgnoreCase((String)this.sendProperties.get("mail.smtp.auth"));
    }

    @Override
    public void destroy() {
    }

    @Override
    public Mail createMail(Tenant tenant, String charset) {
        String buf = charset;
        if (buf == null) {
            buf = this.mailCharset;
        }
        return new Mail(buf);
    }

    @Override
    public void sendMail(Tenant tenant, Mail mail) {
        try {
            InternetAddress address;
            String charset = mail.getCharset();
            if (charset == null || charset.length() == 0) {
                charset = this.mailCharset;
            }
            boolean isDefault = false;
            TenantMailInfo tenantMailInfo = tenant.getTenantConfig(TenantMailInfo.class);
            if (mail.getFromAddress() == null) {
                isDefault = true;
                address = new InternetAddress(tenantMailInfo.getMailFrom(), tenantMailInfo.getMailFromName(), charset);
                address.validate();
                mail.setFromAddress(address);
            }
            if (mail.getReplyToAddress() == null) {
                if (isDefault && tenantMailInfo.getMailReply() != null && tenantMailInfo.getMailReply().length() != 0) {
                    address = new InternetAddress(tenantMailInfo.getMailReply(), tenantMailInfo.getMailReplyName(), charset);
                    address.validate();
                    mail.setReplyToAddress(address);
                } else {
                    mail.setReplyToAddress(mail.getFromAddress());
                }
            }
            if (!this.fireOnSendMail(mail)) {
                return;
            }
            if (!tenantMailInfo.isSendMailEnable()) {
                logger.debug("send mail flag of tenat configration is off, so don't send mail.");
                return;
            }
            Exception ex = null;
            boolean isSuccess = false;
            for (int i = 0; i <= this.retryCount; ++i) {
                if (ex != null) {
                    if (this.retryIntervalMillis > 0L) {
                        Thread.sleep(this.retryIntervalMillis);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.warn("Exception occured while send mail:" + ex + ", so retry...", (Throwable)ex);
                    } else {
                        logger.warn("Exception occured while send mail:" + ex + ", so retry...");
                    }
                }
                try {
                    MimeMessage mimeMessage = this.createSendMailMessage(mail, charset);
                    Transport.send((Message)mimeMessage);
                    isSuccess = true;
                }
                catch (Exception e) {
                    ex = e;
                }
                if (isSuccess) break;
            }
            if (!isSuccess) {
                throw ex;
            }
            this.fireOnSuccess(mail);
        }
        catch (Exception e) {
            this.handleException(mail, e);
        }
    }

    private MimeMessage createSendMailMessage(Mail mail, String charset) throws UnsupportedEncodingException, MessagingException {
        Properties props = this.createSendMailProperty(mail);
        if (logger.isDebugEnabled()) {
            logger.debug("send mail props:" + props);
        }
        Session session = this.mailSmtpPopbeforesmtp ? this.execPopBeforeSmtp(mail, props) : this.createSendMailSession(mail, props);
        if (this.debug) {
            session.setDebug(true);
        }
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)mail.getFromAddress());
        message.setReplyTo(new Address[]{mail.getReplyToAddress()});
        this.setRecipients(mail, message);
        message.setSubject(mail.getSubject(), charset);
        this.setMessage(mail, message, charset);
        Date d = mail.getDate();
        if (d == null) {
            d = new Date();
        }
        message.setSentDate(d);
        return message;
    }

    protected final void setRecipients(Mail mail, MimeMessage message) throws MessagingException {
        List<InternetAddress> bufBcc;
        List<InternetAddress> bufCc;
        boolean validate = false;
        List<InternetAddress> bufTo = mail.getRecipientTo();
        if (bufTo != null && bufTo.size() > 0) {
            validate = true;
            message.addRecipients(Message.RecipientType.TO, bufTo.toArray(new Address[bufTo.size()]));
        }
        if ((bufCc = mail.getRecipientCc()) != null && bufCc.size() > 0) {
            validate = true;
            message.addRecipients(Message.RecipientType.CC, bufCc.toArray(new Address[bufCc.size()]));
        }
        if ((bufBcc = mail.getRecipientBcc()) != null && bufBcc.size() > 0) {
            validate = true;
            message.addRecipients(Message.RecipientType.BCC, bufBcc.toArray(new Address[bufBcc.size()]));
        }
        if (!validate) {
            throw new MailException("no send to (or cc or bcc) address specified.");
        }
    }

    private String handlePlainText(String text, String charset) {
        if (ISO_2022_JP.equalsIgnoreCase(charset) && !text.endsWith("\r\n")) {
            return text + "\r\n";
        }
        return text;
    }

    protected final void setMessage(Mail mail, MimeMessage message, String charset) throws MessagingException {
        boolean hasAtt;
        boolean isAlt = mail.getMessage() != null && mail.getMessage().length() != 0 && mail.getHtmlMessage() != null && mail.getHtmlMessage().getContent().length() != 0;
        boolean bl = hasAtt = mail.getAttachments() != null;
        if (hasAtt) {
            MimeMultipart multipartMixed = new MimeMultipart("mixed");
            if (!isAlt) {
                if (mail.getMessage() != null && mail.getMessage().length() != 0) {
                    MimeBodyPart plainMessageBodyPart = new MimeBodyPart();
                    plainMessageBodyPart.setContent((Object)this.handlePlainText(mail.getMessage(), charset), "text/plain; charset=" + charset);
                    multipartMixed.addBodyPart((BodyPart)plainMessageBodyPart);
                    plainMessageBodyPart.setHeader("Content-Transfer-Encoding", this.mailEncoding);
                } else {
                    MimeBodyPart htmlMessageBodyPart = new MimeBodyPart();
                    String htmlCharset = mail.getHtmlMessage().getCharset();
                    if (htmlCharset == null) {
                        htmlCharset = charset;
                    }
                    htmlMessageBodyPart.setContent((Object)mail.getHtmlMessage().getContent(), "text/html; charset=" + htmlCharset);
                    multipartMixed.addBodyPart((BodyPart)htmlMessageBodyPart);
                }
            } else {
                MimeBodyPart altBodyPart = new MimeBodyPart();
                MimeMultipart multipartAlt = new MimeMultipart("alternative");
                altBodyPart.setContent((Multipart)multipartAlt);
                MimeBodyPart plainMessageBodyPart = new MimeBodyPart();
                plainMessageBodyPart.setContent((Object)this.handlePlainText(mail.getMessage(), charset), "text/plain; charset=" + charset);
                multipartAlt.addBodyPart((BodyPart)plainMessageBodyPart);
                plainMessageBodyPart.setHeader("Content-Transfer-Encoding", this.mailEncoding);
                MimeBodyPart htmlMessageBodyPart = new MimeBodyPart();
                String htmlCharset = mail.getHtmlMessage().getCharset();
                if (htmlCharset == null) {
                    htmlCharset = charset;
                }
                htmlMessageBodyPart.setContent((Object)mail.getHtmlMessage().getContent(), "text/html; charset=" + htmlCharset);
                multipartAlt.addBodyPart((BodyPart)htmlMessageBodyPart);
                multipartMixed.addBodyPart((BodyPart)altBodyPart);
            }
            for (DataHandler at : mail.getAttachments()) {
                MimeBodyPart attBodyPart = new MimeBodyPart();
                attBodyPart.setDataHandler(at);
                try {
                    String fileName = at.getName();
                    attBodyPart.setFileName(fileName);
                    String contentType = at.getContentType();
                    if (contentType != null) {
                        String fileNameEnc = MimeUtility.quote((String)MimeUtility.encodeText((String)fileName), (String)"()<>@,;:\\\"\t []/?=");
                        StringBuilder sb = new StringBuilder();
                        sb.append(contentType);
                        sb.append(";\r\n");
                        sb.append(" name=");
                        sb.append(MimeUtility.fold((int)7, (String)fileNameEnc));
                        attBodyPart.setHeader("Content-Type", sb.toString());
                    }
                }
                catch (UnsupportedEncodingException e) {
                    logger.warn("file name cant encoded... cause " + e.getMessage(), (Throwable)e);
                }
                attBodyPart.setDisposition("attachment");
                multipartMixed.addBodyPart((BodyPart)attBodyPart);
            }
            message.setContent((Multipart)multipartMixed);
        } else if (!isAlt) {
            if (mail.getMessage() != null && mail.getMessage().length() != 0) {
                message.setText(this.handlePlainText(mail.getMessage(), charset), charset);
                message.setHeader("Content-Transfer-Encoding", this.mailEncoding);
            } else {
                String htmlCharset = mail.getHtmlMessage().getCharset();
                if (htmlCharset == null) {
                    htmlCharset = charset;
                }
                message.setContent((Object)mail.getHtmlMessage().getContent(), "text/html; charset=\"" + htmlCharset + "\"");
            }
        } else {
            MimeMultipart multipart = new MimeMultipart("alternative");
            MimeBodyPart plainMessageBodyPart = new MimeBodyPart();
            plainMessageBodyPart.setContent((Object)this.handlePlainText(mail.getMessage(), charset), "text/plain; charset=\"" + charset + "\"");
            multipart.addBodyPart((BodyPart)plainMessageBodyPart);
            plainMessageBodyPart.setHeader("Content-Transfer-Encoding", this.mailEncoding);
            MimeBodyPart htmlMessageBodyPart = new MimeBodyPart();
            String htmlCharset = mail.getHtmlMessage().getCharset();
            if (htmlCharset == null) {
                htmlCharset = charset;
            }
            htmlMessageBodyPart.setContent((Object)mail.getHtmlMessage().getContent(), "text/html; charset=\"" + htmlCharset + "\"");
            multipart.addBodyPart((BodyPart)htmlMessageBodyPart);
            message.setContent((Multipart)multipart);
        }
    }

    private Session execPopBeforeSmtp(Mail mail, Properties props) {
        Session session = this.createPopSession(mail, props);
        if (this.debug) {
            session.setDebug(true);
        }
        Store store = null;
        try {
            store = session.getStore("pop3");
            store.connect();
        }
        catch (NoSuchProviderException e) {
            throw new MailException("Pop Before SMTP user auth fail.", e);
        }
        catch (MessagingException e) {
            throw new MailException("Pop Before SMTP user auth fail.", e);
        }
        finally {
            if (store != null) {
                try {
                    store.close();
                }
                catch (MessagingException e) {
                    logger.error("can't close pop3 store:" + (Object)((Object)e), (Throwable)e);
                }
            }
        }
        return session;
    }

    private Session createPopSession(Mail mail, Properties props) {
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(MailServiceImpl.this.mailPop3AuthId, MailServiceImpl.this.mailPop3AuthPassword);
            }
        });
        return session;
    }

    private Session createSendMailSession(Mail mail, Properties props) {
        Authenticator authenticator = null;
        if (this.mailSmtpAuth) {
            authenticator = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(MailServiceImpl.this.mailSmtpAuthId, MailServiceImpl.this.mailSmtpAuthPassword);
                }
            };
        }
        Session session = authenticator == null ? Session.getInstance((Properties)props) : Session.getInstance((Properties)props, (Authenticator)authenticator);
        return session;
    }

    private Properties createSendMailProperty(Mail mail) {
        Properties props = new Properties();
        props.putAll(this.sendProperties);
        props.setProperty("mail.from", mail.getFromAddress().getAddress());
        if (mail.getReturnPath() != null) {
            props.setProperty("mail.smtp.from", mail.getReturnPath());
        }
        return props;
    }

    protected boolean fireOnSendMail(Mail mail) {
        if (this.listener != null) {
            for (SendMailListener l : this.listener) {
                if (l.beforeSend(mail)) continue;
                logger.info("send mail canceled by Listener:" + l);
                return false;
            }
        }
        return true;
    }

    protected void fireOnSuccess(Mail mail) {
        if (this.listener != null) {
            for (SendMailListener l : this.listener) {
                l.onSuccess(mail);
            }
        }
    }

    protected void handleException(Mail mail, Exception e) {
        if (this.listener != null) {
            for (SendMailListener l : this.listener) {
                if (l.onFailure(mail, e)) continue;
                return;
            }
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new MailException(e.getMessage(), e);
    }

    @Override
    public Class<MetaMailTemplate> getMetaDataType() {
        return MetaMailTemplate.class;
    }

    @Override
    public Class<MetaMailTemplate.MailTemplateRuntime> getRuntimeType() {
        return MetaMailTemplate.MailTemplateRuntime.class;
    }

    public static class TypeMap
    extends DefinitionMetaDataTypeMap<MailTemplateDefinition, MetaMailTemplate> {
        public TypeMap() {
            super(MailServiceImpl.getFixedPath(), MetaMailTemplate.class, MailTemplateDefinition.class);
        }

        @Override
        public TypedDefinitionManager<MailTemplateDefinition> typedDefinitionManager() {
            return ManagerLocator.getInstance().getManager(MailTemplateDefinitionManager.class);
        }
    }
}

