/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.message;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.iplass.mtp.impl.i18n.I18nService;
import org.iplass.mtp.impl.message.MessageService;
import org.iplass.mtp.impl.message.MetaMessageCategory;
import org.iplass.mtp.impl.message.MetaMessageItem;
import org.iplass.mtp.spi.ServiceRegistry;

public class MessageResourceBundle
extends ResourceBundle {
    private String baseBundleName;
    String lang;
    private ResourceBundle wrapped;
    private MessageService service = ServiceRegistry.getRegistry().getService(MessageService.class);

    public MessageResourceBundle(String baseBundleName, Locale locale, ResourceBundle wrapped) {
        this.baseBundleName = baseBundleName;
        I18nService i18n = ServiceRegistry.getRegistry().getService(I18nService.class);
        Locale langLocale = i18n.selectLangLocale(locale);
        this.lang = langLocale.toLanguageTag();
        this.wrapped = wrapped;
    }

    @Override
    public String getBaseBundleName() {
        return this.baseBundleName;
    }

    @Override
    protected Object handleGetObject(String key) {
        MetaMessageCategory.MetaMessageCategoryHandler handler = (MetaMessageCategory.MetaMessageCategoryHandler)this.service.getRuntimeByName(this.baseBundleName);
        if (handler != null) {
            return handler.getMessageString(key, this.lang);
        }
        if (this.wrapped != null) {
            return this.wrapped.getObject(key);
        }
        return null;
    }

    @Override
    public Enumeration<String> getKeys() {
        MetaMessageCategory.MetaMessageCategoryHandler handler = (MetaMessageCategory.MetaMessageCategoryHandler)this.service.getRuntimeByName(this.baseBundleName);
        if (handler != null) {
            Map<String, MetaMessageItem> map = handler.getMetaData().getMessages();
            if (map == null) {
                return Collections.emptyEnumeration();
            }
            final Iterator<String> keys = map.keySet().iterator();
            return new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return keys.hasNext();
                }

                @Override
                public String nextElement() {
                    return (String)keys.next();
                }
            };
        }
        if (this.wrapped != null) {
            return this.wrapped.getKeys();
        }
        return Collections.emptyEnumeration();
    }
}

