/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.message;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.message.MessageResourceBundle;
import org.iplass.mtp.impl.tenant.MetaTenantI18nInfo;
import org.iplass.mtp.impl.util.UTF8ResourceBundleControl;

public class MessageResourceBundleControl
extends UTF8ResourceBundleControl {
    public static final String MESSAGE_FORMAT_TYPE = "mtp.message";
    private final boolean isFallbackToSystemLocale;
    private final List<String> formats;
    private final List<String> fallbackFormats;

    public MessageResourceBundleControl(boolean isFallbackToSystemLocale, List<String> formats) {
        this.isFallbackToSystemLocale = isFallbackToSystemLocale;
        this.formats = formats;
        this.fallbackFormats = new ArrayList<String>(formats.size());
        boolean afterMsg = false;
        for (String f : formats) {
            if (f.equals(MESSAGE_FORMAT_TYPE)) {
                afterMsg = true;
                continue;
            }
            if (!afterMsg) continue;
            this.fallbackFormats.add(f);
        }
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        if (format.equals(MESSAGE_FORMAT_TYPE)) {
            ResourceBundle wrapped = null;
            if (this.fallbackFormats != null) {
                String f;
                Iterator<String> iterator = this.fallbackFormats.iterator();
                while (iterator.hasNext() && (wrapped = super.newBundle(baseName, locale, f = iterator.next(), loader, reload)) == null) {
                }
            }
            return new MessageResourceBundle(baseName, locale, wrapped);
        }
        return super.newBundle(baseName, locale, format, loader, reload);
    }

    @Override
    public List<String> getFormats(String baseName) {
        return this.formats;
    }

    @Override
    public Locale getFallbackLocale(String baseName, Locale locale) {
        Locale l = ExecuteContext.getCurrentContext().getTenantContext().getTenantRuntime().getConfigRuntime(MetaTenantI18nInfo.MetaTenantI18nInfoRuntime.class).getLangLocale();
        if (l != null && !locale.equals(l)) {
            return l;
        }
        if (this.isFallbackToSystemLocale) {
            super.getFallbackLocale(baseName, locale);
        }
        return null;
    }
}

