/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.message;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlRootElement;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.message.MetaMessageItem;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.metadata.MetaDataRuntime;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.validation.ValidationContext;
import org.iplass.mtp.message.MessageCategory;
import org.iplass.mtp.message.MessageItem;
import org.iplass.mtp.util.StringUtil;

@XmlRootElement
public class MetaMessageCategory
extends BaseRootMetaData
implements DefinableMetaData<MessageCategory> {
    private static final long serialVersionUID = 3080437844175871382L;
    private Map<String, MetaMessageItem> messages;
    private static final Pattern namePattern = Pattern.compile("${name}", 16);
    private static final Pattern entityNamePattern = Pattern.compile("${entityName}", 16);

    @Override
    public MetaMessageCategory copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public MetaDataRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new MetaMessageCategoryHandler();
    }

    public Map<String, MessageItem> createMessageItems() {
        if (this.messages == null || this.messages.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, MessageItem> ret = new HashMap<String, MessageItem>(this.messages.size());
        for (Map.Entry<String, MetaMessageItem> metaItem : this.messages.entrySet()) {
            ret.put(metaItem.getKey(), metaItem.getValue().createMessageItem());
        }
        return ret.size() == 0 ? Collections.emptyMap() : ret;
    }

    @Override
    public void applyConfig(MessageCategory definition) {
        this.setName(definition.getName());
        this.setDisplayName(definition.getDisplayName());
        this.setDescription(definition.getDescription());
        this.setMetaMessages(definition.getMessageItems());
    }

    @Override
    public MessageCategory currentConfig() {
        MessageCategory definition = new MessageCategory();
        definition.setName(this.name);
        definition.setDisplayName(this.displayName);
        definition.setDescription(this.description);
        definition.setMessageItems(this.createMessageItems());
        return definition;
    }

    public Map<String, MetaMessageItem> getMessages() {
        return this.messages;
    }

    public void setMessages(Map<String, MetaMessageItem> messages) {
        this.messages = messages;
    }

    public void addMessage(MetaMessageItem metaMessageItem) {
        if (this.messages == null) {
            this.messages = new HashMap<String, MetaMessageItem>();
        }
        this.messages.put(metaMessageItem.getMessageId(), metaMessageItem);
    }

    public void setMetaMessages(Map<String, MessageItem> messages) {
        if (messages == null) {
            return;
        }
        for (Map.Entry<String, MessageItem> messageItem : messages.entrySet()) {
            MetaMessageItem buf = new MetaMessageItem();
            buf.setValue(messageItem.getValue());
            if (buf == null) continue;
            this.addMessage(buf);
        }
    }

    public class MetaMessageCategoryHandler
    extends BaseMetaDataRuntime {
        @Override
        public MetaMessageCategory getMetaData() {
            return MetaMessageCategory.this;
        }

        public MessageItem createMessageItem(String messageId) {
            if (MetaMessageCategory.this.messages == null || MetaMessageCategory.this.messages.size() == 0) {
                return null;
            }
            MetaMessageItem meta = (MetaMessageItem)MetaMessageCategory.this.messages.get(messageId);
            if (meta == null) {
                return null;
            }
            return meta.createMessageItem();
        }

        public String getMessageString(String messageId, String lang) {
            if (MetaMessageCategory.this.messages == null) {
                return null;
            }
            MetaMessageItem item = (MetaMessageItem)MetaMessageCategory.this.messages.get(messageId);
            if (item == null) {
                return null;
            }
            if (lang != null && item.getLocalizedMessageList() != null) {
                for (MetaLocalizedString mls : item.getLocalizedMessageList()) {
                    if (!lang.equals(mls.getLocaleName())) continue;
                    return mls.getStringValue();
                }
            }
            return item.getMessage();
        }

        public String createMessage(MetaMessageItem item, ValidationContext context, String propertyDisplayName, String entityDisplayName) {
            String msg = null;
            if (item != null) {
                String lang;
                msg = item.getMessage();
                HashMap<String, String> localizedStringMap = new HashMap<String, String>();
                if (item.getLocalizedMessageList() != null) {
                    for (MetaLocalizedString mls : item.getLocalizedMessageList()) {
                        localizedStringMap.put(mls.getLocaleName(), mls.getStringValue());
                    }
                }
                if (StringUtil.isNotEmpty((String)localizedStringMap.get(lang = ExecuteContext.getCurrentContext().getLanguage()))) {
                    msg = (String)localizedStringMap.get(lang);
                }
                Entity entity = context.getValidatingDataModel();
                MetaDataEntry entry = MetaDataContext.getContext().getMetaDataEntry(("/entity/" + entity.getDefinitionName()).replace(".", "/"));
                EntityHandler eHandl = (EntityHandler)entry.getRuntime();
                Map<String, String> entityLangMap = eHandl.getLocalizedStringMap();
                PropertyHandler pHandl = eHandl.getProperty(context.getValidatePropertyName(), EntityContext.getCurrentContext());
                Map<String, String> propLangMap = pHandl.getLocalizedStringMap();
                if (msg != null) {
                    String replaceName;
                    if (msg.contains("${name}")) {
                        replaceName = propertyDisplayName;
                        if (propLangMap.get(lang) != null) {
                            replaceName = propLangMap.get(lang);
                        }
                        msg = namePattern.matcher(msg).replaceAll(replaceName);
                    }
                    if (msg.contains("${entityName}")) {
                        replaceName = entityDisplayName;
                        if (entityLangMap.get(lang) != null) {
                            replaceName = entityLangMap.get(lang);
                        }
                        msg = entityNamePattern.matcher(msg).replaceAll(replaceName);
                    }
                }
            }
            return msg;
        }
    }
}

