/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.message.MessageResourceBundleControl;
import org.iplass.mtp.impl.message.MessageService;
import org.iplass.mtp.impl.tenant.MetaTenantI18nInfo;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceInitListener;

public class ResourceBundleConfig
implements ServiceInitListener<MessageService> {
    private String baseBundleNamePattern;
    private List<String> formats;
    private boolean fallbackToSystemLocale;
    private Pattern bbnPtn;
    private ResourceBundle.Control control;

    public String getBaseBundleNamePattern() {
        return this.baseBundleNamePattern;
    }

    public void setBaseBundleNamePattern(String baseBundleNamePattern) {
        this.baseBundleNamePattern = baseBundleNamePattern;
    }

    public List<String> getFormats() {
        return this.formats;
    }

    public void setFormats(List<String> formats) {
        this.formats = formats;
    }

    public boolean isFallbackToSystemLocale() {
        return this.fallbackToSystemLocale;
    }

    public void setFallbackToSystemLocale(boolean fallbackToSystemLocale) {
        this.fallbackToSystemLocale = fallbackToSystemLocale;
    }

    @Override
    public void inited(MessageService service, Config config) {
        if (this.baseBundleNamePattern != null) {
            this.bbnPtn = Pattern.compile(this.baseBundleNamePattern);
        }
        if (this.formats == null) {
            this.formats = new ArrayList<String>();
            this.formats.add("mtp.message");
            this.formats.addAll(ResourceBundle.Control.FORMAT_DEFAULT);
            this.formats = Collections.unmodifiableList(this.formats);
        }
        this.control = this.formats.contains("mtp.message") ? new MessageResourceBundleControl(this.fallbackToSystemLocale, this.formats) : new ResourceBundle.Control(){

            @Override
            public List<String> getFormats(String baseName) {
                return ResourceBundleConfig.this.formats;
            }

            @Override
            public Locale getFallbackLocale(String baseName, Locale locale) {
                Locale l = ExecuteContext.getCurrentContext().getTenantContext().getTenantRuntime().getConfigRuntime(MetaTenantI18nInfo.MetaTenantI18nInfoRuntime.class).getLangLocale();
                if (l != null && !locale.equals(l)) {
                    return l;
                }
                if (ResourceBundleConfig.this.fallbackToSystemLocale) {
                    return super.getFallbackLocale(baseName, locale);
                }
                return null;
            }
        };
    }

    @Override
    public void destroyed() {
    }

    public ResourceBundle.Control getResourceBundleControl() {
        return this.control;
    }

    public boolean isMatch(String baseBundleName) {
        if (this.bbnPtn == null) {
            return true;
        }
        return this.bbnPtn.matcher(baseBundleName).matches();
    }
}

