/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.metadata.MetaDataEntryInfo;
import org.iplass.mtp.impl.metadata.MetaDataRuntimeException;
import org.iplass.mtp.impl.metadata.MetaDataStore;
import org.iplass.mtp.impl.metadata.composite.CompositeMetaDataStore;
import org.iplass.mtp.impl.metadata.rdb.RdbMetaDataStore;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataRepository
implements Service {
    private static Logger logger = LoggerFactory.getLogger(MetaDataRepository.class);
    private MetaDataStore tenantLocalStore;
    private List<MetaDataStore> sharedStore;

    public MetaDataStore getTenantLocalStore() {
        return this.tenantLocalStore;
    }

    public List<MetaDataStore> getSharedStore() {
        return this.sharedStore;
    }

    public MetaDataEntry loadById(int tenantId, String id, boolean withShared) {
        MetaDataEntry ent = this.tenantLocalStore.loadById(tenantId, id);
        if (ent != null) {
            ent.setRepositryType(MetaDataEntry.RepositoryType.TENANT_LOCAL);
            return ent;
        }
        if (this.sharedStore != null && withShared) {
            for (int i = 0; i < this.sharedStore.size(); ++i) {
                ent = this.sharedStore.get(i).loadById(tenantId, id);
                if (ent == null || !ent.isSharable()) continue;
                if (ent.isOverwritable()) {
                    ent.setRepositryType(MetaDataEntry.RepositoryType.TENANT_LOCAL);
                } else {
                    ent.setRepositryType(MetaDataEntry.RepositoryType.SHARED);
                }
                return ent;
            }
        }
        return null;
    }

    public MetaDataEntry loadById(int tenantId, String id, int version, boolean withShared) {
        MetaDataEntry ent = this.tenantLocalStore.loadById(tenantId, id, version);
        if (ent != null) {
            ent.setRepositryType(MetaDataEntry.RepositoryType.TENANT_LOCAL);
            return ent;
        }
        if (this.sharedStore != null && withShared) {
            for (int i = 0; i < this.sharedStore.size(); ++i) {
                ent = this.sharedStore.get(i).loadById(tenantId, id, version);
                if (ent == null || !ent.isSharable()) continue;
                if (ent.isOverwritable()) {
                    ent.setRepositryType(MetaDataEntry.RepositoryType.TENANT_LOCAL);
                } else {
                    ent.setRepositryType(MetaDataEntry.RepositoryType.SHARED);
                }
                return ent;
            }
        }
        return null;
    }

    public List<MetaDataEntryInfo> definitionList(int tenantId, String prefixPath, boolean withShared) throws MetaDataRuntimeException {
        HashMap<String, MetaDataEntryInfo> map = new HashMap<String, MetaDataEntryInfo>();
        if (this.sharedStore != null && withShared) {
            for (int i = this.sharedStore.size() - 1; i > -1; --i) {
                List<MetaDataEntryInfo> list = this.sharedStore.get(i).definitionList(tenantId, prefixPath);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    MetaDataEntryInfo definition = (MetaDataEntryInfo)iterator.next();
                    if (!definition.isSharable()) continue;
                    if (definition.isOverwritable()) {
                        definition.setRepositryType(MetaDataEntry.RepositoryType.TENANT_LOCAL);
                    } else {
                        definition.setRepositryType(MetaDataEntry.RepositoryType.SHARED);
                    }
                    map.put(definition.getPath(), definition);
                }
            }
        }
        List<MetaDataEntryInfo> list = this.tenantLocalStore.definitionList(tenantId, prefixPath);
        for (MetaDataEntryInfo definition : list) {
            definition.setRepositryType(MetaDataEntry.RepositoryType.TENANT_LOCAL);
            map.put(definition.getPath(), definition);
        }
        ArrayList<MetaDataEntryInfo> res = new ArrayList<MetaDataEntryInfo>(map.values());
        return res;
    }

    @Override
    public void destroy() {
        this.tenantLocalStore = null;
        this.sharedStore = null;
    }

    @Override
    public void init(Config config) {
        this.tenantLocalStore = (MetaDataStore)config.getBean("tenantLocalStore");
        this.sharedStore = config.getBeans("sharedStore");
    }

    public MetaDataEntry load(int tenantId, String path, boolean withShared) throws MetaDataRuntimeException {
        MetaDataEntry ent = this.tenantLocalStore.load(tenantId, path);
        if (ent != null) {
            ent.setRepositryType(MetaDataEntry.RepositoryType.TENANT_LOCAL);
            return ent;
        }
        if (this.sharedStore != null && withShared) {
            for (int i = 0; i < this.sharedStore.size(); ++i) {
                ent = this.sharedStore.get(i).load(tenantId, path);
                if (ent == null || !ent.isSharable()) continue;
                if (ent.getMetaData() == null) {
                    throw new SystemException(tenantId + "'s " + path + " MetaData is Incompatible or not defined.");
                }
                if (ent.isOverwritable()) {
                    ent.setRepositryType(MetaDataEntry.RepositoryType.TENANT_LOCAL);
                } else {
                    ent.setRepositryType(MetaDataEntry.RepositoryType.SHARED);
                }
                return ent;
            }
        }
        return null;
    }

    public MetaDataEntry load(int tenantId, String path, int version, boolean withShared) throws MetaDataRuntimeException {
        MetaDataEntry ent = this.tenantLocalStore.load(tenantId, path, version);
        if (ent != null) {
            ent.setRepositryType(MetaDataEntry.RepositoryType.TENANT_LOCAL);
            return ent;
        }
        if (this.sharedStore != null && withShared) {
            for (int i = 0; i < this.sharedStore.size(); ++i) {
                ent = this.sharedStore.get(i).load(tenantId, path, version);
                if (ent == null || !ent.isSharable()) continue;
                if (ent.getMetaData() == null) {
                    throw new SystemException(tenantId + "'s " + path + " MetaData is Incompatible or not defined.");
                }
                if (ent.isOverwritable()) {
                    ent.setRepositryType(MetaDataEntry.RepositoryType.TENANT_LOCAL);
                } else {
                    ent.setRepositryType(MetaDataEntry.RepositoryType.SHARED);
                }
                return ent;
            }
        }
        return null;
    }

    public void store(int tenantId, MetaDataEntry metaDataEntry) throws MetaDataRuntimeException {
        this.tenantLocalStore.store(tenantId, metaDataEntry);
        logger.info("store MetaData:" + metaDataEntry.getPath());
    }

    public void update(int tenantId, MetaDataEntry metaDataEntry) throws MetaDataRuntimeException {
        this.tenantLocalStore.update(tenantId, metaDataEntry);
        logger.info("update MetaData:" + metaDataEntry.getPath());
    }

    public void remove(int tenantId, String path) throws MetaDataRuntimeException {
        this.tenantLocalStore.remove(tenantId, path);
        logger.info("remove MetaData:" + path);
    }

    public void updateConfigById(int tenantId, String id, MetaDataConfig config) {
        this.tenantLocalStore.updateConfigById(tenantId, id, config);
        logger.info("update MetaData config of id:" + id);
    }

    public boolean hasOverwriteMetaData(int sharedTenantId, MetaDataEntry entry) {
        if (this.tenantLocalStore instanceof RdbMetaDataStore) {
            return ((RdbMetaDataStore)this.tenantLocalStore).hasOverwriteMetaData(sharedTenantId, entry.getMetaData().getId());
        }
        if (this.tenantLocalStore instanceof CompositeMetaDataStore) {
            return ((CompositeMetaDataStore)this.tenantLocalStore).hasOverwriteMetaData(sharedTenantId, entry);
        }
        return false;
    }

    public List<Integer> getOverwriteTenantIdList(int sharedTenantId, String metaDataId) {
        if (this.tenantLocalStore instanceof RdbMetaDataStore) {
            return ((RdbMetaDataStore)this.tenantLocalStore).getOverwriteTenantIdList(sharedTenantId, metaDataId);
        }
        if (this.tenantLocalStore instanceof CompositeMetaDataStore) {
            return ((CompositeMetaDataStore)this.tenantLocalStore).getOverwriteTenantIdList(sharedTenantId, metaDataId);
        }
        return new ArrayList<Integer>();
    }

    public List<MetaDataEntryInfo> getInvalidEntryList(int tenantId) {
        if (this.getTenantLocalStore() instanceof RdbMetaDataStore) {
            return ((RdbMetaDataStore)this.getTenantLocalStore()).getInvalidEntryList(tenantId);
        }
        if (this.getTenantLocalStore() instanceof CompositeMetaDataStore) {
            return ((CompositeMetaDataStore)this.getTenantLocalStore()).getInvalidEntryList(tenantId);
        }
        return Collections.emptyList();
    }

    public void purgeById(int tenantId, String id) throws MetaDataRuntimeException {
        if (this.getTenantLocalStore() instanceof RdbMetaDataStore) {
            ((RdbMetaDataStore)this.getTenantLocalStore()).purgeById(tenantId, id);
        } else if (this.getTenantLocalStore() instanceof CompositeMetaDataStore) {
            ((CompositeMetaDataStore)this.getTenantLocalStore()).purgeById(tenantId, id);
        }
    }

    public List<MetaDataEntryInfo> getHistoryById(int tenantId, String definitionId) throws MetaDataRuntimeException {
        List<MetaDataEntryInfo> list = this.tenantLocalStore.getHistoryById(tenantId, definitionId);
        return list;
    }
}

