/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.metadata.binary.jaxb;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.metadata.binary.ArchiveBinaryMetaData;
import org.iplass.mtp.impl.metadata.binary.BinaryMetaData;
import org.iplass.mtp.impl.metadata.binary.BinaryMetaDataService;
import org.iplass.mtp.impl.metadata.binary.SimpleBinaryMetaData;
import org.iplass.mtp.impl.metadata.binary.jaxb.Chunk;
import org.iplass.mtp.spi.ServiceRegistry;

public class ChunkedBinary {
    static final String TYPE_ARCHIVE = "archive";
    private String name;
    private String type;
    private List<Chunk> chunk;

    public ChunkedBinary(BinaryMetaData binMeta) {
        if (binMeta instanceof ArchiveBinaryMetaData) {
            this.type = TYPE_ARCHIVE;
        }
        this.name = binMeta.getName();
        BinaryMetaDataService service = ServiceRegistry.getRegistry().getService(BinaryMetaDataService.class);
        this.chunk = new ArrayList<Chunk>();
        for (long offset = 0L; offset < binMeta.getSize(); offset += (long)service.getXmlBinaryChunkSize()) {
            int length = (int)Math.min((long)service.getXmlBinaryChunkSize(), binMeta.getSize() - offset);
            this.chunk.add(new Chunk(offset, length, binMeta));
        }
    }

    public ChunkedBinary() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<Chunk> getChunk() {
        return this.chunk;
    }

    public void setChunk(List<Chunk> chunk) {
        this.chunk = chunk;
    }

    public BinaryMetaData toBinaryMetaData() throws IOException {
        BinaryMetaData binMeta = TYPE_ARCHIVE.equals(this.type) ? new ArchiveBinaryMetaData(this.name) : new SimpleBinaryMetaData(this.name);
        if (this.chunk != null && this.chunk.size() > 0) {
            try (OutputStream os = binMeta.getOutputStream();){
                for (Chunk c : this.chunk) {
                    os.write(c.getBin());
                }
            }
        }
        return binMeta;
    }

    public void dispose() {
        if (this.chunk != null) {
            for (Chunk c : this.chunk) {
                c.dispose();
            }
        }
    }
}

