/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.metadata.xmlfile;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.iplass.mtp.impl.metadata.MetaDataRepository;
import org.iplass.mtp.impl.metadata.MetaDataRuntimeException;
import org.iplass.mtp.impl.metadata.xmlfile.XmlExternalRefHandler;
import org.iplass.mtp.impl.metadata.xmlfile.XmlFileMetaDataStore;
import org.iplass.mtp.impl.metadata.xmlfile.dom.DomHandler;
import org.iplass.mtp.impl.metadata.xmlfile.dom.DomHandlerFactory;
import org.iplass.mtp.impl.metadata.xmlfile.dom.XsiTypeDomHandlerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DomXmlExternalRefHandler
implements XmlExternalRefHandler {
    private static final int XML_INDENT_NUM = 4;
    private String charset = "UTF-8";
    private DomHandlerFactory domHandlerFactory = new XsiTypeDomHandlerFactory();

    public DomHandlerFactory getDomHandlerFactory() {
        return this.domHandlerFactory;
    }

    @Override
    public void putOutExtcontent(File xml) {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xml);
            doc.getDocumentElement().normalize();
            DomHandler handler = this.resolveDomHamdler(doc, xml);
            handler.putUnescapedExtFiles(doc);
            this.transform(doc, xml);
            this.deleteUnrefFiles(xml, handler.refFiles());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new MetaDataRuntimeException(e);
        }
    }

    @Override
    public byte[] readRestoringExtContent(File xml) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xml);
            doc.getDocumentElement().normalize();
            DomHandler handler = this.resolveDomHamdler(doc, xml);
            handler.restoreFromUnescapedExtFiles(doc);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(new DOMSource(doc), new StreamResult(out));
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            throw new MetaDataRuntimeException(e);
        }
        return out.toByteArray();
    }

    private void transform(Document document, File xml) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", new Integer(4));
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            ByteArrayOutputStream bos = this.createDocType();
            transformer.transform(new DOMSource(document), new StreamResult(new OutputStreamWriter((OutputStream)bos, this.charset)));
            Files.write(xml.toPath(), bos.toByteArray(), new OpenOption[0]);
        }
        catch (IOException | TransformerException e) {
            throw new MetaDataRuntimeException(e);
        }
    }

    private ByteArrayOutputStream createDocType() throws UnsupportedEncodingException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)bos, this.charset));
        writer.println("<?xml version=\"1.0\" encoding=\"" + this.charset + "\" standalone=\"yes\"?>");
        writer.println("<!DOCTYPE metaDataEntry>");
        writer.flush();
        writer.close();
        return bos;
    }

    private void deleteUnrefFiles(File xml, List<String> refFiles) {
        File dir = xml.getParentFile();
        for (String fileName : dir.list()) {
            if (!fileName.startsWith(xml.getName() + ".") || refFiles.contains(fileName)) continue;
            File unReferencedFile = new File(dir, fileName);
            unReferencedFile.delete();
        }
    }

    private DomHandler resolveDomHamdler(Document doc, File xml) {
        return this.domHandlerFactory.createDomHamdler(xml, this.charset, doc);
    }

    @Override
    public void inited(MetaDataRepository service, XmlFileMetaDataStore xmlfileMetaDataStore) {
        this.domHandlerFactory.inited(service, xmlfileMetaDataStore);
    }
}

