/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.parser;

import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.parser.SyntaxService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyntaxParser {
    private static Logger logger = LoggerFactory.getLogger(SyntaxParser.class);
    private SyntaxContext sc;

    public SyntaxParser(String contextName) {
        SyntaxService service = ServiceRegistry.getRegistry().getService(SyntaxService.class);
        this.sc = service.getSyntaxContext(contextName);
    }

    public <T extends ASTNode> T parse(String src, Class<? extends Syntax<T>> parseAs) throws ParseException {
        long time = 0L;
        if (logger.isTraceEnabled()) {
            time = System.nanoTime();
        }
        Syntax<T> syntax = this.sc.getSyntax(parseAs);
        ParseContext ctx = new ParseContext(src);
        ctx.consumeChars(ParseContext.WHITE_SPACES);
        ASTNode node = (ASTNode)syntax.parse(ctx);
        ctx.consumeChars(ParseContext.WHITE_SPACES);
        if (logger.isTraceEnabled()) {
            logger.trace("parse query:time=" + (double)(System.nanoTime() - time) / 1000000.0 + "ms.");
        }
        if (!ctx.isEnd()) {
            throw new ParseException(new EvalError("Cant handle next token.", syntax, ctx));
        }
        return (T)node;
    }
}

