/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.prefs;

import groovy.lang.GroovyClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.prefs.MetaPreference;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.prefs.Preference;
import org.iplass.mtp.prefs.PreferenceSet;

public class MetaPreferenceSet
extends MetaPreference {
    private static final long serialVersionUID = -4873425413256055751L;
    private List<MetaPreference> subSet;

    public List<MetaPreference> getSubSet() {
        return this.subSet;
    }

    public void setSubSet(List<MetaPreference> subSet) {
        this.subSet = subSet;
    }

    @Override
    public PreferenceSetRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new PreferenceSetRuntime();
    }

    @Override
    public void applyConfig(Preference def) {
        super.applyConfig(def);
        PreferenceSet defSet = (PreferenceSet)def;
        if (defSet.getSubSet() != null) {
            ArrayList<MetaPreference> set = new ArrayList<MetaPreference>();
            for (Preference p : defSet.getSubSet()) {
                MetaPreference mp = MetaPreference.newMeta(p);
                mp.applyConfig(p);
                set.add(mp);
            }
            this.subSet = set;
        } else {
            this.subSet = null;
        }
    }

    @Override
    public Preference currentConfig() {
        PreferenceSet def = new PreferenceSet();
        this.fillTo(def);
        if (this.subSet != null) {
            ArrayList<Preference> set = new ArrayList<Preference>();
            for (MetaPreference mp : this.subSet) {
                set.add(mp.currentConfig());
            }
            def.setSubSet(set);
        }
        return def;
    }

    public class PreferenceSetRuntime
    extends MetaPreference.PreferenceRuntime {
        protected Map<String, Object> map = new HashMap<String, Object>();

        public PreferenceSetRuntime() {
            if (MetaPreferenceSet.this.getValue() != null) {
                this.map.put("value", MetaPreferenceSet.this.getValue());
            }
            if (MetaPreferenceSet.this.subSet != null) {
                this.applyToMap(this.map, MetaPreferenceSet.this.subSet);
            }
            this.map = Collections.unmodifiableMap(this.map);
            try {
                if (MetaPreferenceSet.this.subSet != null && this.runtime != null) {
                    ScriptEngine se = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
                    GroovyScriptEngine gse = (GroovyScriptEngine)se;
                    GroovyClassLoader cl = gse.getSharedClassLoader();
                    this.applyToBean(this.runtime, MetaPreferenceSet.this.subSet, (ClassLoader)cl);
                }
            }
            catch (RuntimeException e) {
                this.setIllegalStateException(e);
            }
            catch (Exception e) {
                this.setIllegalStateException(new IllegalStateException(e));
            }
        }

        @Override
        public Map<String, Object> getMap() {
            return this.map;
        }

        private void applyToMap(Map<String, Object> map, List<MetaPreference> set) {
            if (set != null) {
                for (MetaPreference metaPreference : set) {
                    Object pre = map.get(metaPreference.getName());
                    if (metaPreference instanceof MetaPreferenceSet) {
                        Map<String, Object> subMap = new HashMap<String, Object>();
                        this.applyToMap(subMap, ((MetaPreferenceSet)metaPreference).getSubSet());
                        subMap = Collections.unmodifiableMap(subMap);
                        if (pre == null) {
                            map.put(metaPreference.getName(), subMap);
                            continue;
                        }
                        if (pre instanceof Map) {
                            ArrayList<Map> newMaps = new ArrayList<Map>();
                            newMaps.add((Map)pre);
                            newMaps.add(subMap);
                            map.put(metaPreference.getName(), newMaps);
                            continue;
                        }
                        if (!(pre instanceof List)) continue;
                        ((List)pre).add(subMap);
                        continue;
                    }
                    if (pre == null) {
                        map.put(metaPreference.getName(), metaPreference.getValue());
                        continue;
                    }
                    if (pre instanceof String) {
                        ArrayList<String> newStrs = new ArrayList<String>();
                        newStrs.add((String)pre);
                        newStrs.add(metaPreference.getValue());
                        map.put(metaPreference.getName(), newStrs);
                        continue;
                    }
                    if (!(pre instanceof List)) continue;
                    ((List)pre).add(metaPreference.getValue());
                }
                for (Map.Entry entry : map.entrySet()) {
                    if (!(entry.getValue() instanceof List)) continue;
                    entry.setValue(Collections.unmodifiableList((List)entry.getValue()));
                }
            }
        }

        @Override
        public MetaPreferenceSet getMetaData() {
            return MetaPreferenceSet.this;
        }
    }
}

