/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.properties.basic;

import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.definition.properties.DateProperty;
import org.iplass.mtp.impl.properties.basic.BasicType;
import org.iplass.mtp.impl.properties.basic.DateTimeType;
import org.iplass.mtp.impl.util.ConvertUtil;
import org.iplass.mtp.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateType
extends BasicType {
    private static final long serialVersionUID = -273797137918846755L;
    private static final int hash = 20;
    private static Logger logger = LoggerFactory.getLogger(DateType.class);

    @Override
    public int hashCode() {
        return 20;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof DateType;
    }

    @Override
    public DateProperty createPropertyDefinitionInstance() {
        return new DateProperty();
    }

    @Override
    public DateType copy() {
        return new DateType();
    }

    @Override
    public Class<?> storeType() {
        return Date.class;
    }

    @Override
    public PropertyDefinitionType getEnumType() {
        return PropertyDefinitionType.DATE;
    }

    @Override
    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (DateTimeType.OLD_FORMAT_FLAG) {
            return DateUtil.getDateInstance(2, false).format(value);
        }
        SimpleDateFormat sdf = DateUtil.getSimpleDateFormat("yyyy-MM-dd", false);
        return sdf.format(value);
    }

    @Override
    public Object fromString(String strValue) {
        if (strValue == null) {
            return null;
        }
        try {
            if (DateTimeType.OLD_FORMAT_FLAG) {
                return new Date(DateUtil.getDateInstance(2, false).parse(strValue).getTime());
            }
            SimpleDateFormat sdf = DateUtil.getSimpleDateFormat("yyyy-MM-dd", false);
            return new Date(sdf.parse(strValue).getTime());
        }
        catch (ParseException e) {
            try {
                return ConvertUtil.convertFromString(Date.class, strValue);
            }
            catch (RuntimeException ee) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Can't parse to Date:" + strValue);
                }
                return null;
            }
        }
    }
}

