/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.properties.basic;

import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.definition.properties.IntegerProperty;
import org.iplass.mtp.impl.properties.basic.BasicType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegerType
extends BasicType {
    private static final long serialVersionUID = 7889923978274416939L;
    private static final int hash = 23;
    private static Logger logger = LoggerFactory.getLogger(IntegerType.class);

    @Override
    public int hashCode() {
        return 23;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof IntegerType;
    }

    @Override
    public IntegerProperty createPropertyDefinitionInstance() {
        return new IntegerProperty();
    }

    @Override
    public IntegerType copy() {
        return new IntegerType();
    }

    @Override
    public Class<?> storeType() {
        return Long.class;
    }

    @Override
    public PropertyDefinitionType getEnumType() {
        return PropertyDefinitionType.INTEGER;
    }

    @Override
    public Object fromString(String strValue) {
        if (strValue == null) {
            return null;
        }
        try {
            return Long.valueOf(strValue);
        }
        catch (NumberFormatException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Can't parse to Integer:" + strValue);
            }
            return null;
        }
    }
}

