/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.properties.extend;

import java.io.IOException;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import org.codehaus.groovy.runtime.MethodClosure;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.definition.properties.AutoNumberProperty;
import org.iplass.mtp.entity.definition.properties.NumberingType;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.counter.CounterService;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyType;
import org.iplass.mtp.impl.properties.basic.StringType;
import org.iplass.mtp.impl.properties.extend.ComplexWrapperType;
import org.iplass.mtp.impl.properties.extend.ComplexWrapperTypeLoadAdapter;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.ScriptRuntimeException;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateBinding;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.util.StringUtil;

public class AutoNumberType
extends ComplexWrapperType {
    private static final long serialVersionUID = 5091141571328404880L;
    public static final String ACCEPT_SKIP_COUNTER_SERVICE_NAME = "AutoNumberTypeCounterAcceptSkip";
    public static final String NO_SKIP_COUNTER_SERVICE_NAME = "AutoNumberTypeCounterNoSkip";
    private static StringType actualType = new StringType();
    private static ComplexWrapperTypeLoadAdapter loadAdaper = new ComplexWrapperTypeLoadAdapter(){

        @Override
        public void setContext(EntityContext context) {
        }

        @Override
        public void nextCalled(List<Object> values) {
        }

        @Override
        public Object toComplexWrapperTypeValue(Object value) {
            return value;
        }

        @Override
        public Object[] newComplexWrapperTypeArray(int size) {
            return new String[size];
        }

        @Override
        public void close() {
        }
    };
    private int fixedNumberOfDigits = -1;
    private String formatScript;
    private long startsWith = 0L;
    private NumberingType numberingType = NumberingType.ALLOW_SKIPPING;

    public static String createIncrementUnitKey(String entityDefId, String propDefId) {
        return entityDefId + "." + propDefId;
    }

    @Override
    public boolean isCompatibleTo(PropertyType another) {
        if (another instanceof AutoNumberType) {
            return true;
        }
        return super.isCompatibleTo(another);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fixedNumberOfDigits;
        result = 31 * result + (this.formatScript == null ? 0 : this.formatScript.hashCode());
        result = 31 * result + (this.numberingType == null ? 0 : this.numberingType.hashCode());
        result = 31 * result + (int)(this.startsWith ^ this.startsWith >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AutoNumberType other = (AutoNumberType)obj;
        if (this.fixedNumberOfDigits != other.fixedNumberOfDigits) {
            return false;
        }
        if (this.formatScript == null ? other.formatScript != null : !this.formatScript.equals(other.formatScript)) {
            return false;
        }
        if (this.numberingType != other.numberingType) {
            return false;
        }
        return this.startsWith == other.startsWith;
    }

    public NumberingType getNumberingType() {
        return this.numberingType;
    }

    public void setNumberingType(NumberingType numberingType) {
        this.numberingType = numberingType;
    }

    public long getStartsWith() {
        return this.startsWith;
    }

    public void setStartsWith(long startsWith) {
        this.startsWith = startsWith;
    }

    public int getFixedNumberOfDigits() {
        return this.fixedNumberOfDigits;
    }

    public void setFixedNumberOfDigits(int fixedNumberOfDigits) {
        this.fixedNumberOfDigits = fixedNumberOfDigits;
    }

    public String getFormatScript() {
        return this.formatScript;
    }

    public void setFormatScript(String formatScript) {
        this.formatScript = formatScript;
    }

    @Override
    public PropertyType actualType() {
        return actualType;
    }

    @Override
    public PropertyDefinitionType getEnumType() {
        return PropertyDefinitionType.AUTONUMBER;
    }

    @Override
    public PropertyDefinitionType getDataStoreEnumType() {
        return PropertyDefinitionType.STRING;
    }

    @Override
    public PropertyDefinition createPropertyDefinitionInstance() {
        AutoNumberProperty p = new AutoNumberProperty();
        p.setFixedNumberOfDigits(this.fixedNumberOfDigits);
        p.setFormatScript(this.formatScript);
        p.setStartsWith(this.startsWith);
        p.setNumberingType(this.numberingType);
        return p;
    }

    @Override
    public void applyDefinition(PropertyDefinition def) {
        super.applyDefinition(def);
        AutoNumberProperty ap = (AutoNumberProperty)def;
        this.fixedNumberOfDigits = ap.getFixedNumberOfDigits();
        this.formatScript = ap.getFormatScript();
        this.startsWith = ap.getStartsWith();
        this.numberingType = ap.getNumberingType();
    }

    @Override
    public PropertyType copy() {
        AutoNumberType copy = new AutoNumberType();
        copy.fixedNumberOfDigits = this.fixedNumberOfDigits;
        copy.formatScript = this.formatScript;
        copy.startsWith = this.startsWith;
        copy.numberingType = this.numberingType;
        return copy;
    }

    @Override
    public Object createRuntime(MetaProperty metaProperty, MetaEntity metaEntity) {
        return new AutoNumberTypeRuntime(metaEntity.getId(), metaProperty.getId());
    }

    @Override
    public ComplexWrapperTypeLoadAdapter createLoadAdapter() {
        return loadAdaper;
    }

    @Override
    public boolean isNeedPrevStoreTypeValueOnToStoreTypeValue() {
        return false;
    }

    @Override
    public Object toStoreTypeValue(Object extendTypeValue, Object prevStoreTypeValue, PropertyHandler ph, EntityHandler eh, String oid, Long version, Entity entity) {
        if (extendTypeValue != null) {
            return extendTypeValue;
        }
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        if (eh.isUseSharedData()) {
            tenantId = ServiceRegistry.getRegistry().getService(TenantContextService.class).getSharedTenantId();
        }
        return ((AutoNumberTypeRuntime)((PrimitivePropertyHandler)ph).getTypeSpecificRuntime()).newValue(tenantId, entity);
    }

    @Override
    public void notifyAfterDelete(Object storeTypeValue, PropertyHandler ph, EntityHandler eh, String oid, Long rbid) {
    }

    @Override
    public void notifyAfterPurge(EntityHandler eh, Long rbid) {
    }

    @Override
    public void notifyAfterRestore(EntityHandler eh, Long rbid) {
    }

    @Override
    public Class<?> extendType() {
        return String.class;
    }

    @Override
    public String toString(Object value) {
        return actualType.toString(value);
    }

    @Override
    public Object fromString(String strValue) {
        return actualType.fromString(strValue);
    }

    @Override
    public ValueExpression translate(EntityField field) {
        return field;
    }

    public class AutoNumberTypeRuntime {
        GroovyTemplate compiledFormatScript;
        CounterService counter;
        private String incrementUnitKey;

        public AutoNumberTypeRuntime(String entityDefId, String propDefId) {
            if (AutoNumberType.this.formatScript != null) {
                ScriptEngine se = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
                this.compiledFormatScript = GroovyTemplateCompiler.compile(AutoNumberType.this.formatScript, "AutoNumberFormat_" + GroovyTemplateCompiler.randomName(), (GroovyScriptEngine)se);
            }
            this.counter = AutoNumberType.this.numberingType == NumberingType.ALLOW_SKIPPING ? (CounterService)ServiceRegistry.getRegistry().getService(AutoNumberType.ACCEPT_SKIP_COUNTER_SERVICE_NAME) : (CounterService)ServiceRegistry.getRegistry().getService(AutoNumberType.NO_SKIP_COUNTER_SERVICE_NAME);
            this.incrementUnitKey = AutoNumberType.createIncrementUnitKey(entityDefId, propDefId);
        }

        String newValue(int tenantId, Entity entity) {
            if (this.compiledFormatScript == null) {
                return this.increment(tenantId);
            }
            StringWriter sw = new StringWriter();
            try {
                this.compiledFormatScript.doTemplate(new AutoNumberGroovyTemplateBinding(sw, tenantId, entity));
            }
            catch (IOException e) {
                throw new ScriptRuntimeException("can not generate auto number:" + e.getMessage(), e);
            }
            return sw.toString();
        }

        public long currentValue() {
            int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
            return this.counter.current(tenantId, this.incrementUnitKey);
        }

        public void resetCounter(long startsWith) {
            int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
            this.counter.resetCounter(tenantId, this.incrementUnitKey, startsWith - 1L);
        }

        String increment(int tenantId) {
            Long v = this.counter.increment(tenantId, this.incrementUnitKey, AutoNumberType.this.getStartsWith());
            String vStr = Long.toString(v);
            if (AutoNumberType.this.fixedNumberOfDigits >= 0 && AutoNumberType.this.fixedNumberOfDigits >= vStr.length()) {
                vStr = StringUtil.leftPad(vStr, AutoNumberType.this.fixedNumberOfDigits, '0');
            }
            return vStr;
        }

        private class AutoNumberGroovyTemplateBinding
        extends GroovyTemplateBinding {
            private int tenantId;

            AutoNumberGroovyTemplateBinding(StringWriter out, int tenantId, Entity entity) throws IOException {
                super(out);
                this.tenantId = tenantId;
                ExecuteContext ex = ExecuteContext.getCurrentContext();
                Timestamp date = ex.getCurrentTimestamp();
                this.setVariable("date", date);
                this.setVariable("user", AuthContextHolder.getAuthContext().newUserBinding());
                this.setVariable("entity", entity);
                SimpleDateFormat f = DateUtil.getSimpleDateFormat("yyyy", true);
                this.setVariable("yyyy", f.format(date));
                f.applyPattern("MM");
                this.setVariable("MM", f.format(date));
                f.applyPattern("dd");
                this.setVariable("dd", f.format(date));
                f.applyPattern("HH");
                this.setVariable("HH", f.format(date));
                f.applyPattern("mm");
                this.setVariable("mm", f.format(date));
                f.applyPattern("ss");
                this.setVariable("ss", f.format(date));
                this.setVariable("nextVal", new MethodClosure((Object)this, "nextVal"));
            }

            public String nextVal() {
                return AutoNumberTypeRuntime.this.increment(this.tenantId);
            }
        }
    }
}

