/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.properties.extend.select;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.definition.LocalizedSelectValueDefinition;
import org.iplass.mtp.entity.definition.properties.selectvalue.SelectValueDefinition;
import org.iplass.mtp.impl.i18n.EnableLanguages;
import org.iplass.mtp.impl.i18n.I18nService;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.spi.ServiceRegistry;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Value
implements Serializable {
    private static final long serialVersionUID = 2187443429118008336L;
    private static I18nService i18nService = ServiceRegistry.getRegistry().getService(I18nService.class);
    String value;
    String displayName;
    private List<MetaLocalizedString> localizedDisplayNameList;

    public static SelectValueDefinition toSelectValueDefinition(List<Value> values) {
        SelectValueDefinition def = new SelectValueDefinition();
        if (values != null) {
            int i;
            List<EnableLanguages> els = i18nService.getEnableLanguages();
            List[] lsvl = new List[els.size()];
            for (i = 0; i < values.size(); ++i) {
                Value val = values.get(i);
                def.addSelectValue(new SelectValue(val.getValue(), val.getDisplayName()));
                if (val.getLocalizedDisplayNameList() == null) continue;
                block1: for (int j = 0; j < els.size(); ++j) {
                    for (MetaLocalizedString mls : val.getLocalizedDisplayNameList()) {
                        if (!els.get(j).getLanguageKey().equals(mls.getLocaleName())) continue;
                        if (lsvl[j] == null) {
                            lsvl[j] = new ArrayList(values.size());
                        }
                        lsvl[j].add(new SelectValue(val.getValue(), mls.getStringValue()));
                        continue block1;
                    }
                }
            }
            for (i = 0; i < els.size(); ++i) {
                def.addLocalizedSelectValue(new LocalizedSelectValueDefinition(els.get(i).getLanguageKey(), lsvl[i]));
            }
        }
        return def;
    }

    public static List<Value> toValues(SelectValueDefinition def) {
        ArrayList<Value> values = new ArrayList<Value>();
        if (def.getSelectValueList() != null) {
            for (SelectValue v : def.getSelectValueList()) {
                Value value = new Value(v.getValue(), v.getDisplayName());
                ArrayList<MetaLocalizedString> mlsList = new ArrayList<MetaLocalizedString>();
                if (def.getLocalizedSelectValueList() != null) {
                    block1: for (LocalizedSelectValueDefinition lsvd : def.getLocalizedSelectValueList()) {
                        if (lsvd.getSelectValueList() == null) continue;
                        for (SelectValue lsv : lsvd.getSelectValueList()) {
                            if (!v.getValue().equals(lsv.getValue())) continue;
                            MetaLocalizedString mls = new MetaLocalizedString();
                            mls.setLocaleName(lsvd.getLocaleName());
                            mls.setStringValue(lsv.getDisplayName());
                            mlsList.add(mls);
                            continue block1;
                        }
                    }
                }
                if (mlsList.size() > 0) {
                    value.setLocalizedDisplayNameList(mlsList);
                }
                values.add(value);
            }
        }
        return values;
    }

    public List<MetaLocalizedString> getLocalizedDisplayNameList() {
        return this.localizedDisplayNameList;
    }

    public void setLocalizedDisplayNameList(List<MetaLocalizedString> localizedDisplayNameList) {
        this.localizedDisplayNameList = localizedDisplayNameList;
    }

    public Value() {
    }

    public Value(String value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Value other = (Value)obj;
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

