/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.iplass.mtp.entity.query.hint.Hint;
import org.iplass.mtp.entity.query.hint.HintComment;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.SyntaxParser;
import org.iplass.mtp.impl.query.QuerySyntaxRegister;
import org.iplass.mtp.impl.query.hint.HintCommentSyntax;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryService
implements Service {
    private static Logger logger = LoggerFactory.getLogger(QueryService.class);
    private String externalHintFile;
    private Map<String, HintComment> externalHints;
    private SyntaxParser queryParser = new SyntaxParser(QuerySyntaxRegister.QUERY_CONTEXT);

    @Override
    public void init(Config config) {
        this.externalHints = new HashMap<String, HintComment>();
        Map inlineExternalHints = config.getValue("externalHints", Map.class);
        if (inlineExternalHints != null) {
            for (Map.Entry e : inlineExternalHints.entrySet()) {
                try {
                    HintComment hintComment = (HintComment)this.queryParser.parse("/*+ " + (String)e.getValue() + " */", HintCommentSyntax.class);
                    if (hintComment.getHintList() == null || hintComment.getHintList().size() <= 0) continue;
                    this.externalHints.put((String)e.getKey(), hintComment);
                }
                catch (ParseException exp) {
                    throw new ServiceConfigrationException("Can't parse externalHint:" + (String)e.getValue(), exp);
                }
            }
        }
        this.externalHintFile = config.getValue("externalHintFile");
        if (this.externalHintFile != null) {
            Properties prop = this.getProperties(this.externalHintFile);
            for (String key : prop.stringPropertyNames()) {
                String val = prop.getProperty(key);
                if (val == null || (val = val.trim()).isEmpty()) continue;
                try {
                    HintComment hintComment = (HintComment)this.queryParser.parse("/*+ " + val + " */", HintCommentSyntax.class);
                    if (hintComment.getHintList() == null || hintComment.getHintList().size() <= 0) continue;
                    this.externalHints.put(key, hintComment);
                }
                catch (ParseException e) {
                    throw new ServiceConfigrationException("Can't parse externalHint:" + val, e);
                }
            }
        }
    }

    private Properties getProperties(String fileName) {
        Properties prop;
        block32: {
            prop = new Properties();
            Path path = Paths.get(fileName, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                if (logger.isDebugEnabled()) {
                    logger.debug("load ExternalHintFile from file path:" + fileName);
                }
                try (InputStreamReader is = new InputStreamReader((InputStream)new FileInputStream(path.toFile()), "utf-8");){
                    prop.load(is);
                    break block32;
                }
                catch (IOException e) {
                    throw new ServiceConfigrationException(e);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("load ExternalHintFile from classpath:" + fileName);
            }
            try (InputStream is = this.getClass().getResourceAsStream(fileName);){
                if (is == null) {
                    logger.error("ExternalHintFile:" + fileName + " not found.Can not initialize QueryService.");
                    throw new ServiceConfigrationException("ExternalHintFile:" + fileName + " Not Found.");
                }
                InputStreamReader isr = new InputStreamReader(is, "utf-8");
                prop.load(isr);
            }
            catch (IOException e) {
                throw new ServiceConfigrationException(e);
            }
        }
        return prop;
    }

    @Override
    public void destroy() {
    }

    public SyntaxParser getQueryParser() {
        return this.queryParser;
    }

    public String getExternalHintFile() {
        return this.externalHintFile;
    }

    public List<Hint> getExternalHint(String key) {
        if (this.externalHints == null) {
            return Collections.emptyList();
        }
        HintComment hc = this.externalHints.get(key);
        if (hc == null) {
            return Collections.emptyList();
        }
        HintComment copy = (HintComment)hc.copy();
        return copy.getHintList();
    }
}

