/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query;

import org.iplass.mtp.entity.query.AsOf;
import org.iplass.mtp.entity.query.Refer;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.AsOfSyntax;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.condition.expr.OrSyntax;
import org.iplass.mtp.impl.query.value.primary.EntityFieldSyntax;

public class ReferSyntax
implements Syntax<Refer>,
QueryConstants {
    private OrSyntax or;
    private EntityFieldSyntax entityField;
    private AsOfSyntax asOf;

    @Override
    public void init(SyntaxContext context) {
        this.or = context.getSyntax(OrSyntax.class);
        this.entityField = context.getSyntax(EntityFieldSyntax.class);
        this.asOf = context.getSyntax(AsOfSyntax.class);
    }

    @Override
    public Refer parse(ParseContext str) throws ParseException {
        if (!str.equalsNextToken("REFER", ParseContext.TOKEN_DELIMITERS)) {
            throw new ParseException(new EvalError("refer expected.", this, str));
        }
        str.consumeChars("REFER".length());
        if (!str.consumeChars(ParseContext.WHITE_SPACES)) {
            throw new ParseException(new EvalError("space expected.", this, str));
        }
        EntityField referenceName = this.entityField.parse(str);
        str.consumeChars(ParseContext.WHITE_SPACES);
        AsOf ao = null;
        if (str.equalsNextToken("AS", ParseContext.TOKEN_DELIMITERS)) {
            ao = this.asOf.parse(str);
            str.consumeChars(ParseContext.WHITE_SPACES);
        }
        Condition cond = null;
        if (str.equalsNextToken("ON", ParseContext.TOKEN_DELIMITERS)) {
            str.consumeChars("ON".length());
            if (!str.consumeChars(ParseContext.WHITE_SPACES)) {
                throw new ParseException(new EvalError("space expected.", this, str));
            }
            cond = this.or.parse(str);
            str.consumeChars(ParseContext.WHITE_SPACES);
        }
        if (cond == null && ao == null) {
            throw new ParseException(new EvalError("'AS OF' or 'ON' expected.", this, str));
        }
        Refer r = new Refer(referenceName, cond);
        if (ao != null) {
            r.setAsOf(ao);
        }
        return r;
    }
}

