/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query.condition.predicate;

import org.iplass.mtp.entity.query.condition.predicate.Like;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.value.primary.LiteralSyntax;

public class LikeSyntax
implements Syntax<Like>,
QueryConstants {
    private LiteralSyntax literalSyntax;

    @Override
    public void init(SyntaxContext context) {
        this.literalSyntax = context.getSyntax(LiteralSyntax.class);
    }

    @Override
    public Like parse(ParseContext str) throws ParseException {
        if (!str.equalsNextToken("LIKE", ParseContext.TOKEN_DELIMITERS)) {
            throw new ParseException(new EvalError("like expected.", this, str));
        }
        str.consumeChars("LIKE".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        Literal pattern = this.literalSyntax.parse(str);
        if (!(pattern.getValue() instanceof String)) {
            throw new ParseException(new EvalError("string expression expected.", this, str));
        }
        str.consumeChars(ParseContext.WHITE_SPACES);
        Like.CaseType ct = Like.CaseType.CI;
        if (str.equalsNextToken("CI", ParseContext.TOKEN_DELIMITERS)) {
            ct = Like.CaseType.CI;
            str.consumeChars("CI".length());
            str.consumeChars(ParseContext.WHITE_SPACES);
        } else if (str.equalsNextToken("CS", ParseContext.TOKEN_DELIMITERS)) {
            ct = Like.CaseType.CS;
            str.consumeChars("CS".length());
            str.consumeChars(ParseContext.WHITE_SPACES);
        }
        Like like = new Like();
        like.setPatternAsLiteral(pattern);
        like.setCaseType(ct);
        return like;
    }
}

