/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query.condition.predicate;

import java.util.ArrayList;
import org.iplass.mtp.entity.query.condition.predicate.Between;
import org.iplass.mtp.entity.query.condition.predicate.ComparisonPredicate;
import org.iplass.mtp.entity.query.condition.predicate.Contains;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.entity.query.condition.predicate.IsNotNull;
import org.iplass.mtp.entity.query.condition.predicate.IsNull;
import org.iplass.mtp.entity.query.condition.predicate.Like;
import org.iplass.mtp.entity.query.condition.predicate.Predicate;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.condition.predicate.BetweenSyntax;
import org.iplass.mtp.impl.query.condition.predicate.ComparisonPredicateSyntax;
import org.iplass.mtp.impl.query.condition.predicate.ContainsSyntax;
import org.iplass.mtp.impl.query.condition.predicate.InSyntax;
import org.iplass.mtp.impl.query.condition.predicate.IsNotNullSyntax;
import org.iplass.mtp.impl.query.condition.predicate.IsNullSyntax;
import org.iplass.mtp.impl.query.condition.predicate.LikeSyntax;
import org.iplass.mtp.impl.query.value.expr.PolynomialSyntax;

public class PredicateSyntax
implements Syntax<Predicate>,
QueryConstants {
    private ComparisonPredicateSyntax comparisonPredicate;
    private BetweenSyntax between;
    private InSyntax in;
    private IsNotNullSyntax isNotNull;
    private IsNullSyntax isNull;
    private LikeSyntax like;
    private PolynomialSyntax primaryValue;
    private ContainsSyntax contains;

    @Override
    public void init(SyntaxContext context) {
        this.primaryValue = context.getSyntax(PolynomialSyntax.class);
        this.comparisonPredicate = context.getSyntax(ComparisonPredicateSyntax.class);
        this.between = context.getSyntax(BetweenSyntax.class);
        this.in = context.getSyntax(InSyntax.class);
        this.isNotNull = context.getSyntax(IsNotNullSyntax.class);
        this.isNull = context.getSyntax(IsNullSyntax.class);
        this.like = context.getSyntax(LikeSyntax.class);
        this.contains = context.getSyntax(ContainsSyntax.class);
    }

    @Override
    public Predicate parse(ParseContext str) throws ParseException {
        int index = str.getCurrentIndex();
        if (str.startsWith("(")) {
            str.consumeChars("(".length());
            str.consumeChars(ParseContext.WHITE_SPACES);
            try {
                boolean isFirst = true;
                ArrayList<ValueExpression> props = new ArrayList<ValueExpression>();
                while (isFirst || !isFirst && str.startsWith(",")) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        str.consumeChars(",".length());
                        str.consumeChars(ParseContext.WHITE_SPACES);
                    }
                    props.add(this.primaryValue.parse(str));
                }
                if (str.startsWith(")") && props.size() >= 2) {
                    str.consumeChars(")".length());
                    str.consumeChars(ParseContext.WHITE_SPACES);
                    In i = this.in.parse(str);
                    i.setPropertyList(props);
                    return i;
                }
                str.setCurrentIndex(index);
            }
            catch (ParseException e) {
                str.setCurrentIndex(index);
            }
        }
        if (str.equalsNextToken("contains", ParseContext.TOKEN_DELIMITERS)) {
            Contains con = this.contains.parse(str);
            return con;
        }
        ValueExpression ef = this.primaryValue.parse(str);
        if (str.isEnd()) {
            throw new ParseException(new EvalError("Predicate expected.", this, str));
        }
        index = str.getCurrentIndex();
        try {
            ComparisonPredicate cp = this.comparisonPredicate.parse(str);
            cp.setProperty(ef);
            return cp;
        }
        catch (ParseException e) {
            str.setCurrentIndex(index);
            try {
                Like l = this.like.parse(str);
                l.setProperty(ef);
                return l;
            }
            catch (ParseException e2) {
                str.setCurrentIndex(index);
                try {
                    Between b = this.between.parse(str);
                    b.setProperty(ef);
                    return b;
                }
                catch (ParseException e3) {
                    str.setCurrentIndex(index);
                    try {
                        In i = this.in.parse(str);
                        i.setProperty(ef);
                        return i;
                    }
                    catch (ParseException e4) {
                        str.setCurrentIndex(index);
                        try {
                            IsNotNull inn = this.isNotNull.parse(str);
                            inn.setProperty(ef);
                            return inn;
                        }
                        catch (ParseException e5) {
                            str.setCurrentIndex(index);
                            try {
                                IsNull isn = this.isNull.parse(str);
                                isn.setProperty(ef);
                                return isn;
                            }
                            catch (ParseException e6) {
                                str.setCurrentIndex(index);
                                str.setCurrentIndex(index);
                                throw new ParseException(new EvalError("Predicate expected.", this, str));
                            }
                        }
                    }
                }
            }
        }
    }
}

