/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.adapter.bulk;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkDeleteContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.ColumnValue;
import org.iplass.mtp.impl.rdb.adapter.bulk.DynamicColumnValue;
import org.iplass.mtp.impl.rdb.adapter.bulk.FixedExpressionColumnValue;

public class InOperatorBulkDeleteContext
implements BulkDeleteContext {
    private Statement stmt;
    private String baseSql;
    private List<ColumnValue> keyColumnValue;
    private List<List<Object>> keys;

    @Override
    public void setContext(String tableName, List<ColumnValue> keyColumnValue, String additionalConditionExpression, Connection con) throws SQLException {
        this.keyColumnValue = keyColumnValue;
        this.stmt = con.createStatement();
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ").append(tableName).append(" WHERE ");
        if (additionalConditionExpression != null) {
            sb.append("(").append(additionalConditionExpression).append(") AND ");
        }
        if (keyColumnValue.size() == 1) {
            sb.append(keyColumnValue.get(0).colName()).append(" IN ");
        } else {
            sb.append("(");
            for (int i = 0; i < keyColumnValue.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(keyColumnValue.get(i).colName());
            }
            sb.append(") IN ");
        }
        this.baseSql = sb.toString();
        this.keys = new ArrayList<List<Object>>();
    }

    @Override
    public void add(List<Object> key) throws SQLException {
        if (this.keyColumnValue.size() != key.size()) {
            throw new IllegalArgumentException("key length not equals key col length");
        }
        this.keys.add(key);
    }

    @Override
    public void execute() throws SQLException {
        if (this.keys.size() > 0) {
            StringBuilder sb = new StringBuilder(this.baseSql);
            sb.append("(");
            for (int i = 0; i < this.keys.size(); ++i) {
                List<Object> k;
                if (i != 0) {
                    sb.append(",");
                }
                if ((k = this.keys.get(i)).size() == 1) {
                    ColumnValue cv = this.keyColumnValue.get(0);
                    if (cv instanceof FixedExpressionColumnValue) {
                        sb.append(((FixedExpressionColumnValue)cv).fixedValueExpression());
                        continue;
                    }
                    ((DynamicColumnValue)cv).valueExpression(k.get(0), sb);
                    continue;
                }
                sb.append("(");
                for (int j = 0; j < k.size(); ++j) {
                    ColumnValue cv;
                    if (j != 0) {
                        sb.append(",");
                    }
                    if ((cv = this.keyColumnValue.get(j)) instanceof FixedExpressionColumnValue) {
                        sb.append(((FixedExpressionColumnValue)cv).fixedValueExpression());
                        continue;
                    }
                    ((DynamicColumnValue)cv).valueExpression(k.get(j), sb);
                }
                sb.append(")");
            }
            sb.append(")");
            this.stmt.executeUpdate(sb.toString());
            this.keys.clear();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.stmt != null) {
            this.stmt.close();
        }
    }

    @Override
    public int getCurrentSize() {
        if (this.keys == null) {
            return 0;
        }
        return this.keys.size();
    }
}

