/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.common.function;

import java.math.BigDecimal;
import java.util.List;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.Function;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.impl.rdb.adapter.function.BaseFunctionAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;

public class RoundTruncFunctionAdapter
extends BaseFunctionAdapter {
    public RoundTruncFunctionAdapter(String funcName, String sqlFuncName) {
        super(funcName, sqlFuncName);
    }

    @Override
    public Class<?> getType(Function function, FunctionAdapter.ArgumentTypeResolver typeResolver) {
        Object lv;
        List<ValueExpression> args = function.getArguments();
        if (args == null) {
            return null;
        }
        if (args.size() == 1) {
            return Long.class;
        }
        ValueExpression arg2 = args.get(1);
        if (arg2 instanceof Literal && (lv = ((Literal)arg2).getValue()) instanceof Number) {
            long l = ((Number)lv).longValue();
            if (l <= 0L) {
                return Long.class;
            }
            return BigDecimal.class;
        }
        throw new QueryException(function.getName() + " Function's second arg must Literal(Long) value.");
    }
}

