/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.iplass.mtp.impl.rdb.connection.AbstractConnectionFactory;
import org.iplass.mtp.impl.rdb.connection.ConnectionException;
import org.iplass.mtp.spi.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceConnectionFactory
extends AbstractConnectionFactory {
    private static final String JNDI_ENV_PREFIX = "jndienv.";
    private static Logger logger = LoggerFactory.getLogger(DataSourceConnectionFactory.class);
    private DataSource dataSource;

    @Override
    protected Connection getConnectionInternal() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new ConnectionException("can not get DataSource Connection:", e);
        }
    }

    @Override
    public void destroy() {
        this.dataSource = null;
    }

    @Override
    public void init(Config config) {
        super.init(config);
        String dsName = "java:comp/env/jdbc/defaultDS";
        if (config.getValue("dataSourceName") != null) {
            dsName = config.getValue("dataSourceName");
        }
        Hashtable<String, String> jndiEnv = new Hashtable<String, String>();
        for (String n : config.getNames()) {
            if (!n.startsWith(JNDI_ENV_PREFIX)) continue;
            jndiEnv.put(n.substring(JNDI_ENV_PREFIX.length()), config.getValue(n));
        }
        InitialContext context = null;
        try {
            context = jndiEnv.size() > 0 ? new InitialContext(jndiEnv) : new InitialContext();
            this.dataSource = (DataSource)context.lookup(dsName);
        }
        catch (NamingException e) {
            throw new ConnectionException("can not create DataSource:" + dsName, e);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    logger.warn("InitialContext.close() fail.maybe leak... " + e, (Throwable)e);
                }
            }
        }
    }
}

