/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.mysql.function;

import java.sql.Timestamp;
import java.util.List;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.value.primary.Function;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.DateTimeUnit;

public class MysqlDateAddFunctionAdapter
implements FunctionAdapter,
DateTimeUnit {
    @Override
    public void toSQL(FunctionAdapter.FunctionContext context, Function function, RdbAdapter rdb) {
        if (function.getArguments() == null || function.getArguments().size() != 3) {
            throw new QueryException(function.getName() + " must have 3 arguments.");
        }
        String unit = ((String)((Literal)function.getArguments().get(2)).getValue()).toUpperCase();
        if (!(unit.equals("MONTH") || unit.equals("YEAR") || unit.equals("DAY") || unit.equals("HOUR") || unit.equals("MINUTE") || unit.equals("SECOND"))) {
            throw new QueryException("unknown interval unit:" + unit);
        }
        context.append("DATE_ADD(");
        context.appendArgument(function.getArguments().get(0));
        context.append(",INTERVAL (");
        context.appendArgument(function.getArguments().get(1));
        context.append(") ");
        context.append(unit);
        context.append(")");
    }

    @Override
    public void toSQL(StringBuilder context, List<CharSequence> args, RdbAdapter rdb) {
        if (args == null || args.size() != 3) {
            throw new QueryException(this.getFunctionName() + " must have 3 arguments.");
        }
        String unit = args.get(2).toString().toUpperCase();
        if (!(unit.equals("MONTH") || unit.equals("YEAR") || unit.equals("DAY") || unit.equals("HOUR") || unit.equals("MINUTE") || unit.equals("SECOND"))) {
            throw new QueryException("unknown interval unit:" + unit);
        }
        context.append("DATE_ADD(");
        context.append(args.get(0));
        context.append(",INTERVAL (");
        context.append(args.get(1));
        context.append(") ");
        context.append(unit);
        context.append(")");
    }

    @Override
    public String getFunctionName() {
        return "DATE_ADD";
    }

    @Override
    public Class<?> getType(Function function, FunctionAdapter.ArgumentTypeResolver typeResolver) {
        return Timestamp.class;
    }
}

