/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.oracle.function;

import java.sql.Timestamp;
import java.util.List;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.value.primary.Function;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.DateTimeUnit;
import org.iplass.mtp.impl.rdb.oracle.OracleRdbAdapter;

public class OracleDateAddFunctionAdapter
implements FunctionAdapter,
DateTimeUnit {
    @Override
    public void toSQL(FunctionAdapter.FunctionContext context, Function function, RdbAdapter rdb) {
        String unit;
        if (function.getArguments() == null || function.getArguments().size() != 3) {
            throw new QueryException(function.getName() + " must have 3 arguments.");
        }
        switch (unit = ((String)((Literal)function.getArguments().get(2)).getValue()).toUpperCase()) {
            case "YEAR": {
                context.append(((OracleRdbAdapter)rdb).getAddMonthsFunction());
                context.append("(");
                context.appendArgument(function.getArguments().get(0));
                context.append(",");
                context.appendArgument(function.getArguments().get(1));
                context.append("*12)");
                break;
            }
            case "MONTH": {
                context.append(((OracleRdbAdapter)rdb).getAddMonthsFunction());
                context.append("(");
                context.appendArgument(function.getArguments().get(0));
                context.append(",");
                context.appendArgument(function.getArguments().get(1));
                context.append(")");
                break;
            }
            case "DAY": 
            case "HOUR": 
            case "MINUTE": 
            case "SECOND": {
                context.append("((");
                context.appendArgument(function.getArguments().get(0));
                context.append(")+(");
                context.appendArgument(function.getArguments().get(1));
                context.append(")*INTERVAL '1' ");
                context.append(unit);
                context.append(")");
                break;
            }
            default: {
                throw new QueryException("unknown interval unit:" + unit);
            }
        }
    }

    @Override
    public void toSQL(StringBuilder context, List<CharSequence> args, RdbAdapter rdb) {
        String unit;
        if (args == null || args.size() != 3) {
            throw new QueryException(this.getFunctionName() + " must have 3 arguments.");
        }
        switch (unit = args.get(2).toString().toUpperCase()) {
            case "YEAR": {
                context.append(((OracleRdbAdapter)rdb).getAddMonthsFunction());
                context.append("(");
                context.append(args.get(0));
                context.append(",");
                context.append(args.get(1));
                context.append("*12)");
                break;
            }
            case "MONTH": {
                context.append(((OracleRdbAdapter)rdb).getAddMonthsFunction());
                context.append("(");
                context.append(args.get(0));
                context.append(",");
                context.append(args.get(1));
                context.append(")");
                break;
            }
            case "DAY": 
            case "HOUR": 
            case "MINUTE": 
            case "SECOND": {
                context.append("((");
                context.append(args.get(0));
                context.append(")+(");
                context.append(args.get(1));
                context.append(")*INTERVAL '1' ");
                context.append(unit);
                context.append(")");
                break;
            }
            default: {
                throw new QueryException("unknown interval unit:" + unit);
            }
        }
    }

    @Override
    public String getFunctionName() {
        return "DATE_ADD";
    }

    @Override
    public Class<?> getType(Function function, FunctionAdapter.ArgumentTypeResolver typeResolver) {
        return Timestamp.class;
    }
}

