/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.sqlserver.function;

import java.util.List;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.value.primary.Function;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.DateTimeUnit;
import org.iplass.mtp.impl.rdb.sqlserver.SqlServerRdbAdapter;

public class SqlServerDateDiffFunctionAdapter
implements FunctionAdapter,
DateTimeUnit {
    @Override
    public void toSQL(FunctionAdapter.FunctionContext context, Function function, RdbAdapter rdb) {
        if (function.getArguments() == null || function.getArguments().size() != 3) {
            throw new QueryException(function.getName() + " must have 3 arguments.");
        }
        String unit = ((String)((Literal)function.getArguments().get(0)).getValue()).toUpperCase();
        context.append("(");
        switch (unit) {
            case "YEAR": {
                context.append(((SqlServerRdbAdapter)rdb).getMonthsBetweenFunction());
                context.append("(");
                context.append("YEAR");
                context.append(",");
                context.appendArgument(function.getArguments().get(1));
                context.append(",");
                context.appendArgument(function.getArguments().get(2));
                context.append(")");
                break;
            }
            case "MONTH": {
                context.append(((SqlServerRdbAdapter)rdb).getMonthsBetweenFunction());
                context.append("(");
                context.append("MONTH");
                context.append(",");
                context.appendArgument(function.getArguments().get(1));
                context.append(",");
                context.appendArgument(function.getArguments().get(2));
                context.append(")");
                break;
            }
            case "DAY": {
                context.append(((SqlServerRdbAdapter)rdb).getMonthsBetweenFunction());
                context.append("(");
                context.append("SECOND");
                context.append(",");
                context.appendArgument(function.getArguments().get(1));
                context.append(",");
                context.appendArgument(function.getArguments().get(2));
                context.append(")/60/60/24");
                break;
            }
            case "HOUR": {
                context.append(((SqlServerRdbAdapter)rdb).getMonthsBetweenFunction());
                context.append("(");
                context.append("SECOND");
                context.append(",");
                context.appendArgument(function.getArguments().get(1));
                context.append(",");
                context.appendArgument(function.getArguments().get(2));
                context.append(")/60/60");
                break;
            }
            case "MINUTE": {
                context.append(((SqlServerRdbAdapter)rdb).getMonthsBetweenFunction());
                context.append("(");
                context.append("SECOND");
                context.append(",");
                context.appendArgument(function.getArguments().get(1));
                context.append(",");
                context.appendArgument(function.getArguments().get(2));
                context.append(")/60");
                break;
            }
            case "SECOND": {
                context.append(((SqlServerRdbAdapter)rdb).getMonthsBetweenFunction());
                context.append("(");
                context.append("SECOND");
                context.append(",");
                context.appendArgument(function.getArguments().get(1));
                context.append(",");
                context.appendArgument(function.getArguments().get(2));
                context.append(")");
                break;
            }
            default: {
                throw new QueryException("unknown interval unit:" + unit);
            }
        }
        context.append(")");
    }

    @Override
    public void toSQL(StringBuilder context, List<CharSequence> args, RdbAdapter rdb) {
        if (args == null || args.size() != 3) {
            throw new QueryException(this.getFunctionName() + " must have 3 arguments.");
        }
        String unit = args.get(0).toString().toUpperCase();
        context.append("(");
        switch (unit) {
            case "YEAR": {
                context.append(((SqlServerRdbAdapter)rdb).getMonthsBetweenFunction());
                context.append("(");
                context.append("YEAR");
                context.append(",");
                context.append(args.get(1));
                context.append(",");
                context.append(args.get(2));
                context.append(")");
                break;
            }
            case "MONTH": {
                context.append(((SqlServerRdbAdapter)rdb).getMonthsBetweenFunction());
                context.append("(");
                context.append("MONTH");
                context.append(",");
                context.append(args.get(1));
                context.append(",");
                context.append(args.get(2));
                context.append(")");
                break;
            }
            case "DAY": {
                context.append(((SqlServerRdbAdapter)rdb).getMonthsBetweenFunction());
                context.append("(");
                context.append("SECOND");
                context.append(",");
                context.append(args.get(1));
                context.append(",");
                context.append(args.get(2));
                context.append(")/60/60/24");
                break;
            }
            case "HOUR": {
                context.append(((SqlServerRdbAdapter)rdb).getMonthsBetweenFunction());
                context.append("(");
                context.append("SECOND");
                context.append(",");
                context.append(args.get(1));
                context.append(",");
                context.append(args.get(2));
                context.append(")/60/60");
                break;
            }
            case "MINUTE": {
                context.append(((SqlServerRdbAdapter)rdb).getMonthsBetweenFunction());
                context.append("(");
                context.append("SECOND");
                context.append(",");
                context.append(args.get(1));
                context.append(",");
                context.append(args.get(2));
                context.append(")/60");
                break;
            }
            case "SECOND": {
                context.append(((SqlServerRdbAdapter)rdb).getMonthsBetweenFunction());
                context.append("(");
                context.append("SECOND");
                context.append(",");
                context.append(args.get(1));
                context.append(",");
                context.append(args.get(2));
                context.append(")");
                break;
            }
            default: {
                throw new QueryException("unknown interval unit:" + unit);
            }
        }
        context.append(")");
    }

    @Override
    public String getFunctionName() {
        return "DATE_DIFF";
    }

    @Override
    public Class<?> getType(Function function, FunctionAdapter.ArgumentTypeResolver typeResolver) {
        return Long.class;
    }
}

