/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.script;

import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.definition.AbstractTypedDefinitionManager;
import org.iplass.mtp.impl.definition.TypedMetaDataService;
import org.iplass.mtp.impl.metadata.RootMetaData;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.GroovyScriptService;
import org.iplass.mtp.impl.script.MetaUtilityClass;
import org.iplass.mtp.impl.script.ScriptService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.utilityclass.definition.UtilityClassDefinition;
import org.iplass.mtp.utilityclass.definition.UtilityClassDefinitionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilityClassDefinitionManagerImpl
extends AbstractTypedDefinitionManager<UtilityClassDefinition>
implements UtilityClassDefinitionManager {
    private static final Logger logger = LoggerFactory.getLogger(UtilityClassDefinitionManagerImpl.class);
    private GroovyScriptService service = (GroovyScriptService)ServiceRegistry.getRegistry().getService(ScriptService.class);

    @Override
    public <T> T createInstanceAs(Class<T> type, String definitionName) throws ClassNotFoundException {
        GroovyScriptEngine se = (GroovyScriptEngine)ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
        try {
            Class<?> clazz = Class.forName(definitionName, true, (ClassLoader)se.getSharedClassLoader());
            return (T)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            logger.debug("not found utility class. name:" + definitionName, (Throwable)e);
            throw e;
        }
        catch (InstantiationException e) {
            throw new ApplicationException("can not instantiate utility class. name:" + definitionName, e);
        }
        catch (IllegalAccessException e) {
            throw new ApplicationException("illegal access utility class. name:" + definitionName, e);
        }
    }

    @Override
    public Class<UtilityClassDefinition> getDefinitionType() {
        return UtilityClassDefinition.class;
    }

    @Override
    protected RootMetaData newInstance(UtilityClassDefinition definition) {
        return new MetaUtilityClass();
    }

    @Override
    protected TypedMetaDataService getService() {
        return this.service;
    }
}

