/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.sms;

import java.util.List;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.definition.TypedDefinitionManager;
import org.iplass.mtp.impl.definition.AbstractTypedMetaDataService;
import org.iplass.mtp.impl.definition.DefinitionMetaDataTypeMap;
import org.iplass.mtp.impl.sms.SmsService;
import org.iplass.mtp.impl.sms.template.MetaSmsMailTemplate;
import org.iplass.mtp.sms.SendSmsMailListener;
import org.iplass.mtp.sms.SmsException;
import org.iplass.mtp.sms.SmsMail;
import org.iplass.mtp.sms.template.definition.SmsMailTemplateDefinition;
import org.iplass.mtp.sms.template.definition.SmsMailTemplateDefinitionManager;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.tenant.Tenant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsServiceBaseImpl
extends AbstractTypedMetaDataService<MetaSmsMailTemplate, MetaSmsMailTemplate.SmsMailTemplateRuntime>
implements SmsService {
    public static final String SMS_TEMPLATE_META_PATH = "/sms/template/";
    private static Logger logger = LoggerFactory.getLogger(SmsServiceBaseImpl.class);
    private String defaultFrom;
    private List<SendSmsMailListener> listener;

    @Override
    public void init(Config config) {
        this.defaultFrom = config.getValue("defaultFrom");
        if (config.getBeans("listener") != null) {
            this.listener = config.getBeans("listener");
        }
    }

    @Override
    public void destroy() {
    }

    public static String getFixedPath() {
        return SMS_TEMPLATE_META_PATH;
    }

    @Override
    public final void sendSmsMail(Tenant tenant, SmsMail sms) {
        try {
            if (!this.fireOnSendMail(sms)) {
                return;
            }
            this.sendSmsMailImpl(tenant, sms);
            this.fireOnSuccess(sms);
        }
        catch (Exception e) {
            this.handleException(sms, e);
        }
    }

    protected boolean fireOnSendMail(SmsMail mail) {
        if (this.listener != null) {
            for (SendSmsMailListener l : this.listener) {
                if (l.beforeSend(mail)) continue;
                logger.info("send mail canceled by Listener:" + l);
                return false;
            }
        }
        return true;
    }

    protected void fireOnSuccess(SmsMail mail) {
        if (this.listener != null) {
            for (SendSmsMailListener l : this.listener) {
                l.onSuccess(mail);
            }
        }
    }

    protected void handleException(SmsMail mail, Exception e) {
        if (this.listener != null) {
            for (SendSmsMailListener l : this.listener) {
                if (l.onFailure(mail, e)) continue;
                return;
            }
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new SmsException(e.getMessage(), e);
    }

    protected void sendSmsMailImpl(Tenant tenant, SmsMail sms) {
        logger.warn("can't send sms, use TwilioSmsService or own implementation of SmsService.To:" + sms.getTo() + ", From:" + sms.getFrom() + ", Message:" + sms.getMessage());
    }

    @Override
    public SmsMail createMail(Tenant tenant) {
        SmsMail smsMail = new SmsMail();
        smsMail.setFrom(this.defaultFrom);
        return smsMail;
    }

    public String getDefaultFrom() {
        return this.defaultFrom;
    }

    public void setDefaultFrom(String defaultFrom) {
        this.defaultFrom = defaultFrom;
    }

    @Override
    public Class<MetaSmsMailTemplate> getMetaDataType() {
        return MetaSmsMailTemplate.class;
    }

    @Override
    public Class<MetaSmsMailTemplate.SmsMailTemplateRuntime> getRuntimeType() {
        return MetaSmsMailTemplate.SmsMailTemplateRuntime.class;
    }

    public static class TypeMap
    extends DefinitionMetaDataTypeMap<SmsMailTemplateDefinition, MetaSmsMailTemplate> {
        public TypeMap() {
            super(SmsServiceBaseImpl.getFixedPath(), MetaSmsMailTemplate.class, SmsMailTemplateDefinition.class);
        }

        @Override
        public TypedDefinitionManager<SmsMailTemplateDefinition> typedDefinitionManager() {
            return ManagerLocator.getInstance().getManager(SmsMailTemplateDefinitionManager.class);
        }
    }
}

