/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tenant;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.impl.tenant.sql.TenantControlSQL;
import org.iplass.mtp.impl.tenant.sql.TenantSelectSQL;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;

public class TenantService
implements Service {
    private RdbAdapter rdb = ServiceRegistry.getRegistry().getService(RdbAdapterService.class).getRdbAdapter();
    private TenantSelectSQL tenantSelect;
    private TenantControlSQL tenantControl;

    @Override
    public void init(Config config) {
        this.tenantSelect = this.rdb.getQuerySqlCreator(TenantSelectSQL.class);
        this.tenantControl = this.rdb.getUpdateSqlCreator(TenantControlSQL.class);
    }

    @Override
    public void destroy() {
    }

    public Tenant getTenant(final String url) {
        SqlExecuter<Tenant> exec = new SqlExecuter<Tenant>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Tenant logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(TenantService.this.tenantSelect.createSQL(url));
                TenantService.this.tenantSelect.setParameter(TenantService.this.rdb, ps, url);
                try (ResultSet rs = ps.executeQuery();){
                    Tenant tenant = TenantService.this.tenantSelect.createTenant(rs);
                    return tenant;
                }
            }
        };
        return (Tenant)exec.execute(this.rdb, true);
    }

    public Tenant getTenant(final int id) {
        SqlExecuter<Tenant> exec = new SqlExecuter<Tenant>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Tenant logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(TenantService.this.tenantSelect.createSQL());
                TenantService.this.tenantSelect.setParameter(TenantService.this.rdb, ps, id);
                try (ResultSet rs = ps.executeQuery();){
                    Tenant tenant = TenantService.this.tenantSelect.createTenant(rs);
                    return tenant;
                }
            }
        };
        return (Tenant)exec.execute(this.rdb, true);
    }

    public void registTenant(final Tenant tenant, final String registId) {
        SqlExecuter<Void> executer = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(TenantService.this.tenantControl.createRegistSQL(TenantService.this.rdb));
                TenantService.this.tenantControl.setRegistParameter(TenantService.this.rdb, ps, tenant, registId);
                ps.executeUpdate();
                return null;
            }
        };
        executer.execute(this.rdb, true);
    }

    public void updateTenant(Tenant tenant) {
        this.updateTenant(tenant, ExecuteContext.getCurrentContext().getClientId());
    }

    public void updateTenant(Tenant tenant, String updateId) {
        this.updateTenant(tenant, updateId, false);
    }

    public void updateTenant(final Tenant tenant, final String updateId, final boolean forceUpdate) {
        SqlExecuter<Void> executer = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(TenantService.this.tenantControl.createUpdateSQL(TenantService.this.rdb, forceUpdate));
                TenantService.this.tenantControl.setUpdateParameter(TenantService.this.rdb, ps, tenant, updateId, forceUpdate);
                int cnt = ps.executeUpdate();
                if (cnt == 0) {
                    throw new RuntimeException("\u3059\u3067\u306b\u66f4\u65b0\u3055\u308c\u3066\u3044\u308b\u304b\u3001\u524a\u9664\u3055\u308c\u3066\u3044\u308b");
                }
                return null;
            }
        };
        executer.execute(this.rdb, true);
    }

    public List<Integer> getAllTenantIdList() {
        SqlExecuter<List<Integer>> exec = new SqlExecuter<List<Integer>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Integer> logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(TenantService.this.tenantSelect.createAllTenantIdListSQL());
                TenantService.this.tenantSelect.setAllTenantIdListParameter(TenantService.this.rdb, ps);
                try (ResultSet rs = ps.executeQuery();){
                    List<Integer> list = TenantService.this.tenantSelect.getAllTenantIdList(rs);
                    return list;
                }
            }
        };
        return (List)exec.execute(this.rdb, true);
    }
}

