/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class UTF8ResourceBundleControl
extends ResourceBundle.Control {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        if (format.equals("java.properties")) {
            PropertyResourceBundle bundle = null;
            String bundleName = this.toBundleName(baseName, locale);
            if (bundleName.contains("://")) {
                return null;
            }
            String resourceName = this.toResourceName(bundleName, "properties");
            InputStream stream = null;
            try {
                stream = AccessController.doPrivileged(() -> {
                    InputStream is = null;
                    if (reload) {
                        URLConnection connection;
                        URL url = loader.getResource(resourceName);
                        if (url != null && (connection = url.openConnection()) != null) {
                            connection.setUseCaches(false);
                            is = connection.getInputStream();
                        }
                    } else {
                        is = loader.getResourceAsStream(resourceName);
                    }
                    return is;
                });
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getException();
            }
            if (stream != null) {
                try {
                    bundle = new PropertyResourceBundle(new InputStreamReader(stream, "UTF-8"));
                }
                finally {
                    stream.close();
                }
            }
            return bundle;
        }
        return super.newBundle(baseName, locale, format, loader, reload);
    }
}

