/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.util.random;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.iplass.mtp.spi.ServiceConfigrationException;

public class SecureRandomGenerator {
    private final Queue<SecureRandom> randoms = new ConcurrentLinkedQueue<SecureRandom>();
    private final int numBitsOfSecureRandomToken;
    private final int radixOfSecureRandomToken;
    private final boolean useStrongSecureRandom;
    private final String algorithm;
    private final String provider;

    public SecureRandomGenerator(int numBitsOfSecureRandomToken, int radixOfSecureRandomToken, boolean useStrongSecureRandom) {
        this.numBitsOfSecureRandomToken = numBitsOfSecureRandomToken;
        this.radixOfSecureRandomToken = radixOfSecureRandomToken;
        this.useStrongSecureRandom = useStrongSecureRandom;
        this.algorithm = null;
        this.provider = null;
    }

    public SecureRandomGenerator(int numBitsOfSecureRandomToken, int radixOfSecureRandomToken, String algorithm) {
        this.numBitsOfSecureRandomToken = numBitsOfSecureRandomToken;
        this.radixOfSecureRandomToken = radixOfSecureRandomToken;
        this.useStrongSecureRandom = false;
        this.algorithm = algorithm;
        this.provider = null;
    }

    public SecureRandomGenerator(int numBitsOfSecureRandomToken, int radixOfSecureRandomToken, String algorithm, String provider) {
        this.numBitsOfSecureRandomToken = numBitsOfSecureRandomToken;
        this.radixOfSecureRandomToken = radixOfSecureRandomToken;
        this.useStrongSecureRandom = false;
        this.algorithm = algorithm;
        this.provider = provider;
    }

    private SecureRandom createSecureRandom() {
        try {
            SecureRandom sr = null;
            sr = this.algorithm != null ? (this.provider != null ? SecureRandom.getInstance(this.algorithm, this.provider) : SecureRandom.getInstance(this.algorithm)) : (this.useStrongSecureRandom ? SecureRandom.getInstanceStrong() : new SecureRandom());
            sr.nextInt();
            return sr;
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new ServiceConfigrationException("invalid secure random algorithm/provider", e);
        }
    }

    public String secureRandomToken() {
        SecureRandom rand = this.randoms.poll();
        if (rand == null) {
            rand = this.createSecureRandom();
        }
        BigInteger randInt = new BigInteger(this.numBitsOfSecureRandomToken, rand);
        this.randoms.add(rand);
        return randInt.toString(this.radixOfSecureRandomToken);
    }

    public int randomInt(int bound) {
        SecureRandom rand = this.randoms.poll();
        if (rand == null) {
            rand = this.createSecureRandom();
        }
        int randInt = rand.nextInt(bound);
        this.randoms.add(rand);
        return randInt;
    }
}

