/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.validation;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.message.MessageService;
import org.iplass.mtp.impl.message.MetaMessageCategory;
import org.iplass.mtp.impl.message.MetaMessageItem;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.validation.MetaValidation;
import org.iplass.mtp.impl.validation.ValidationContext;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;

public abstract class ValidationHandler {
    private static final Pattern namePattern = Pattern.compile("${name}", 16);
    private static final Pattern entityNamePattern = Pattern.compile("${entityName}", 16);
    protected MetaValidation metaData;

    public ValidationHandler(MetaValidation metaData) {
        this.metaData = metaData;
        this.init();
    }

    public String getErrorMessage() {
        return this.metaData.getErrorMessage();
    }

    public void init() {
    }

    public abstract boolean validate(Object var1, ValidationContext var2);

    public boolean validateArray(Object[] values, ValidationContext context) {
        boolean res = true;
        if (values != null) {
            for (Object v : values) {
                if (!(res &= this.validate(v, context))) break;
            }
        }
        return res;
    }

    public String generateErrorMessage(Object value, ValidationContext context, String propertyDisplayName, String entityDisplayName) {
        String lang;
        MetaMessageItem mmi;
        String temp;
        MessageService ms;
        Object mmc;
        String msg = this.getErrorMessage();
        if ((msg == null || msg.length() == 0) && this.metaData.getMessageCategory() != null && this.metaData.getMessageId() != null && (mmc = (MetaMessageCategory.MetaMessageCategoryHandler)(ms = ServiceRegistry.getRegistry().getService(MessageService.class)).getRuntimeByName(this.metaData.getMessageCategory())) != null && StringUtil.isNotEmpty(temp = ((MetaMessageCategory.MetaMessageCategoryHandler)mmc).createMessage(mmi = ((MetaMessageCategory.MetaMessageCategoryHandler)mmc).getMetaData().getMessages().get(this.metaData.getMessageId()), context, propertyDisplayName, entityDisplayName))) {
            msg = temp;
            return msg;
        }
        HashMap<String, String> localizedStringMap = new HashMap<String, String>();
        if (this.metaData.getLocalizedErrorMessageList() != null) {
            for (MetaLocalizedString mls : this.metaData.getLocalizedErrorMessageList()) {
                localizedStringMap.put(mls.getLocaleName(), mls.getStringValue());
            }
        }
        if (StringUtil.isNotEmpty((String)localizedStringMap.get(lang = ExecuteContext.getCurrentContext().getLanguage()))) {
            msg = (String)localizedStringMap.get(lang);
        }
        Entity entity = context.getValidatingDataModel();
        MetaDataEntry entry = MetaDataContext.getContext().getMetaDataEntry(("/entity/" + entity.getDefinitionName()).replace(".", "/"));
        EntityHandler eHandl = (EntityHandler)entry.getRuntime();
        Map<String, String> entityLangMap = eHandl.getLocalizedStringMap();
        eHandl.getMetaData().getDisplayName();
        PropertyHandler pHandl = eHandl.getProperty(context.getValidatePropertyName(), EntityContext.getCurrentContext());
        Map<String, String> propLangMap = pHandl.getLocalizedStringMap();
        if (msg != null) {
            String replaceName;
            if (msg.contains("${name}")) {
                replaceName = propertyDisplayName;
                if (propLangMap.get(lang) != null) {
                    replaceName = propLangMap.get(lang);
                }
                msg = namePattern.matcher(msg).replaceAll(replaceName);
            }
            if (msg.contains("${entityName}")) {
                replaceName = entityDisplayName;
                if (entityLangMap.get(lang) != null) {
                    replaceName = entityLangMap.get(lang);
                }
                msg = entityNamePattern.matcher(msg).replaceAll(replaceName);
            }
        }
        return msg;
    }

    public String getErrorCode() {
        String code = this.metaData.getErrorCode();
        if (code == null) {
            return "";
        }
        return code;
    }
}

