/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.core.config.ConfigImpl;
import org.iplass.mtp.impl.core.config.ConfigPreprocessor;
import org.iplass.mtp.impl.core.config.NameValue;
import org.iplass.mtp.impl.core.config.ServiceConfig;
import org.iplass.mtp.impl.core.config.ServiceDefinition;
import org.iplass.mtp.impl.core.config.ServiceRegistryInitializer;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ServiceRegistry.class);
    private static ServiceRegistry registry = new ServiceRegistry();
    private final ConcurrentHashMap<String, ServiceEntry> services = new ConcurrentHashMap(32, 0.75f, 1);
    private volatile ServiceDefinition serviceDefinition = this.loadServiceDefinition();
    private volatile boolean destroyed = false;

    public static ServiceRegistry getRegistry() {
        return registry;
    }

    private ServiceRegistry() {
    }

    private ServiceDefinition loadServiceDefinition() {
        String configFileName = ServiceRegistryInitializer.getConfigFileName();
        ConfigPreprocessor[] prepros = this.newConfigPreprocessor();
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{NameValue.class, ServiceConfig.class, ServiceDefinition.class});
            ServiceDefinition serviceDefinition = this.getServiceDefinision(configFileName, context, prepros);
            return serviceDefinition;
        }
        catch (JAXBException e) {
            logger.error("JAXBContext can not initialize.", (Throwable)e);
            throw new ServiceConfigrationException(e);
        }
    }

    private ConfigPreprocessor[] newConfigPreprocessor() {
        List<String> cnames = ServiceRegistryInitializer.getConfigPreprocessorClassNames();
        ConfigPreprocessor[] cps = null;
        if (cnames != null) {
            cps = new ConfigPreprocessor[cnames.size()];
            for (int i = 0; i < cps.length; ++i) {
                try {
                    cps[i] = (ConfigPreprocessor)Class.forName(cnames.get(i)).newInstance();
                    continue;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new ServiceConfigrationException("Can not instanceate ConfigPreprocessor:" + cnames.get(i), e);
                }
            }
        }
        return cps;
    }

    private String readContent(String fileName) {
        InputStream is = null;
        try {
            block15: {
                File file;
                is = this.getClass().getResourceAsStream(fileName);
                if (is == null && (file = new File(fileName)).exists()) {
                    try {
                        is = new FileInputStream(file);
                    }
                    catch (FileNotFoundException e) {
                        if (!logger.isDebugEnabled()) break block15;
                        logger.debug("ConfigFile:" + fileName + " not found.", (Throwable)e);
                    }
                }
            }
            if (is == null) {
                logger.error("ConfigFile:" + fileName + " not found.Can not initialize ServiceRegistry.");
                throw new ServiceConfigrationException("Config File:" + fileName + " Not Found.");
            }
            InputStreamReader r = new InputStreamReader(is, "utf-8");
            StringBuffer str = new StringBuffer();
            char[] buf = new char[1024];
            int length = 0;
            while ((length = r.read(buf)) != -1) {
                str.append(buf, 0, length);
            }
            String string = str.toString();
            return string;
        }
        catch (IOException e) {
            logger.error("Cant read ConfigFile:" + fileName + ".Can not initialize ServiceRegistry.", (Throwable)e);
            throw new ServiceConfigrationException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.warn("resource close failed. Maybe Resource Leak.", (Throwable)e);
                }
            }
        }
    }

    private ServiceDefinition getServiceDefinision(String fileName, JAXBContext context, ConfigPreprocessor[] prepros) {
        String content = this.readContent(fileName);
        if (prepros != null) {
            for (ConfigPreprocessor p : prepros) {
                content = p.preprocess(content, fileName);
            }
        }
        try {
            Unmarshaller um = context.createUnmarshaller();
            ServiceDefinition sd = (ServiceDefinition)um.unmarshal((Reader)new StringReader(content));
            if (prepros != null) {
                ConfigPreprocessor[] configPreprocessorArray = prepros;
                int p = configPreprocessorArray.length;
                for (int i = 0; i < p; ++i) {
                    ConfigPreprocessor p2 = configPreprocessorArray[i];
                    sd = p2.preprocess(sd);
                }
            }
            if (sd.getInherits() != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug(fileName + " inherited " + sd.getInherits()[0]);
                }
                ServiceDefinition inhSd = this.getServiceDefinision(sd.getInherits()[0], context, prepros);
                for (int i = 1; i < sd.getInherits().length; ++i) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(fileName + " inherited " + sd.getInherits()[i]);
                    }
                    inhSd.include(this.getServiceDefinision(sd.getInherits()[i], context, prepros));
                }
                sd.inherit(inhSd);
            }
            if (sd.getIncludes() != null) {
                for (String inc : sd.getIncludes()) {
                    ServiceDefinition incSd = this.getServiceDefinision(inc, context, prepros);
                    sd.include(incSd);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug(fileName + " included " + inc);
                }
            }
            if (logger.isTraceEnabled()) {
                Marshaller m = context.createMarshaller();
                m.setProperty("jaxb.formatted.output", (Object)true);
                StringWriter w = new StringWriter();
                m.marshal((Object)sd, (Writer)w);
                logger.trace("configration of " + fileName + "\n=============\n" + w.toString() + "\n=============");
            }
            return sd;
        }
        catch (JAXBException e) {
            logger.error("Parse failed ConfigFile:" + fileName + ".Can not initialize ServiceRegistry.", (Throwable)e);
            throw new ServiceConfigrationException(e);
        }
    }

    private ServiceEntry createService(String serviceName, List<String> dependStack) {
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            if (this.destroyed) {
                throw new SystemException("service allready destroyed");
            }
            ServiceEntry service = this.services.get(serviceName);
            if (service != null) {
                return service;
            }
            if (dependStack.contains(serviceName)) {
                throw new ServiceConfigrationException("depend loop occured." + dependStack + " " + serviceName);
            }
            dependStack.add(serviceName);
            ServiceConfig sc = this.serviceDefinition.search(serviceName);
            if (sc == null) {
                throw new ServiceConfigrationException(serviceName + " not defined.");
            }
            ConfigImpl config = new ConfigImpl(serviceName, sc.getProperty());
            if (sc.getDepend() != null) {
                for (String depend : sc.getDepend()) {
                    ServiceEntry dependService = this.services.get(depend);
                    if (dependService == null) {
                        dependService = this.createService(depend, dependStack);
                    }
                    config.addDependentService(depend, dependService.service);
                }
            }
            try {
                Class<?> implClassType;
                Class<?> interfaceType = Class.forName(sc.getInterfaceName());
                if (!Service.class.isAssignableFrom(interfaceType)) {
                    logger.error("Can not regist Service." + sc.getInterfaceName() + "must implements Service interface.");
                    throw new ServiceConfigrationException("Can not regist Service." + sc.getInterfaceName() + "must implements Service interface.");
                }
                String className = sc.getClassName();
                if (className == null) {
                    className = sc.getInterfaceName();
                }
                if (!interfaceType.isAssignableFrom(implClassType = Class.forName(className))) {
                    logger.error("Can not regist Service." + sc.getClassName() + "must implements " + sc.getInterfaceName() + " interface.");
                    throw new ServiceConfigrationException("Can not regist Service." + sc.getClassName() + " must implements " + sc.getInterfaceName() + " interface.");
                }
                Service s = (Service)implClassType.newInstance();
                s.init(config);
                config.notifyInited(s);
                ServiceEntry se = new ServiceEntry(serviceName, s, config);
                this.services.put(serviceName, se);
                dependStack.remove(serviceName);
                if (logger.isDebugEnabled()) {
                    logger.debug("Service created: " + serviceName);
                }
                return se;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | RuntimeException e) {
                throw new ServiceConfigrationException("failed to create Service:" + serviceName, e);
            }
        }
    }

    public <T extends Service> T getService(Class<T> serviceClass) {
        return this.getService(serviceClass.getName());
    }

    public <T extends Service> T getService(String serviceName) {
        ServiceEntry se = this.services.get(serviceName);
        if (se == null) {
            try {
                se = this.createService(serviceName, new ArrayList<String>());
            }
            catch (ServiceConfigrationException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ServiceConfigrationException("can not initialize service:" + serviceName, e);
            }
        }
        return (T)se.service;
    }

    public <T extends Service> boolean exists(Class<T> serviceClass) {
        return this.exists(serviceClass.getName());
    }

    public boolean exists(String serviceName) {
        return this.serviceDefinition.search(serviceName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setService(String serviceName, Service service) {
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            if (this.destroyed) {
                throw new SystemException("service already destroyed");
            }
            ServiceEntry previous = this.services.put(serviceName, new ServiceEntry(serviceName, service, null));
            if (previous != null) {
                previous.destroy();
            }
        }
    }

    public void setService(Service service) {
        this.setService(service.getClass().getName(), service);
    }

    public void destroyAllService() {
        this.destroyed = true;
        for (Map.Entry<String, ServiceEntry> e : this.services.entrySet()) {
            e.getValue().destroy();
        }
        this.services.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reInit() {
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            if (this.destroyed) {
                throw new SystemException("service already destroyed");
            }
            ArrayList<ServiceEntry> forDest = new ArrayList<ServiceEntry>(this.services.size());
            for (Map.Entry<String, ServiceEntry> e : this.services.entrySet()) {
                forDest.add(e.getValue());
            }
            this.services.clear();
            this.serviceDefinition = this.loadServiceDefinition();
            for (ServiceEntry se : forDest) {
                se.destroy();
            }
        }
    }

    private static class ServiceEntry {
        private final String name;
        private final Service service;
        private final ConfigImpl config;

        ServiceEntry(String name, Service service, ConfigImpl config) {
            this.name = name;
            this.service = service;
            this.config = config;
        }

        void destroy() {
            try {
                this.service.destroy();
                if (this.config != null) {
                    this.config.notifyDestroyed();
                }
            }
            catch (Exception e) {
                logger.error("service:" + this.name + " destroy process faild. so mybe memory leak. cause:" + e, (Throwable)e);
            }
        }
    }
}

