/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.transaction;

import java.util.function.Function;
import org.iplass.mtp.Manager;
import org.iplass.mtp.transaction.Holder;
import org.iplass.mtp.transaction.Propagation;
import org.iplass.mtp.transaction.RollbackException;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.transaction.TransactionOption;
import org.iplass.mtp.transaction.TransactionStatus;

public interface TransactionManager
extends Manager {
    public Transaction newTransaction();

    public Transaction newTransaction(boolean var1);

    public Transaction suspend();

    public void resume(Transaction var1);

    public Transaction currentTransaction();

    default public <R> R doTransaction(TransactionOption option, Function<Transaction, R> function) {
        Propagation propagation = option.getPropagation();
        Transaction t = this.currentTransaction();
        boolean isSuccess = false;
        boolean isCreate = false;
        Throwable th = null;
        try {
            switch (propagation) {
                case SUPPORTS: {
                    break;
                }
                case NOT_SUPPORTED: {
                    if (t.getStatus() == TransactionStatus.NONE || t.getStatus() == TransactionStatus.SUSPENDED) break;
                    t = this.suspend();
                    isCreate = true;
                    break;
                }
                case REQUIRED: {
                    if (t.getStatus() != TransactionStatus.NONE && t.getStatus() != TransactionStatus.SUSPENDED) break;
                    t = this.newTransaction(option.isReadOnly());
                    isCreate = true;
                    break;
                }
                case REQUIRES_NEW: {
                    t = this.newTransaction(option.isReadOnly());
                    isCreate = true;
                    break;
                }
            }
            R ret = function.apply(t);
            isSuccess = true;
            R r = ret;
            return r;
        }
        catch (Error | RuntimeException e) {
            th = e;
            throw e;
        }
        finally {
            if (isCreate) {
                switch (t.getStatus()) {
                    case SUSPENDED: {
                        this.resume(t);
                        break;
                    }
                    case ACTIVE: {
                        if (isSuccess) {
                            if (t.isRollbackOnly()) {
                                if (Holder.logger.isDebugEnabled()) {
                                    Holder.logger.debug("rollback transaction because set rollbackOnly=true:" + t);
                                }
                                t.rollback();
                                if (!option.isThrowExceptionIfSetRollbackOnly()) break;
                                throw new RollbackException("setRolbackOnly called");
                            }
                            t.commit();
                            break;
                        }
                        if (option.isRollbackWhenException()) {
                            try {
                                if (Holder.logger.isDebugEnabled()) {
                                    Holder.logger.debug("rollback transaction cause " + th + ":" + t, th);
                                }
                                t.rollback();
                            }
                            catch (RuntimeException e) {
                                th.addSuppressed(e);
                            }
                            break;
                        }
                        if (t.isRollbackOnly()) {
                            if (Holder.logger.isDebugEnabled()) {
                                Holder.logger.debug("rollbackWhenException=false, but rollback transaction because set rollbackOnly=true. exception:" + th + ":" + t, th);
                            }
                            try {
                                t.rollback();
                            }
                            catch (RuntimeException e) {
                                th.addSuppressed(e);
                            }
                            break;
                        }
                        if (Holder.logger.isDebugEnabled()) {
                            Holder.logger.debug("rollbackWhenException=false, so commit transaction on exception:" + th + ":" + t, th);
                        }
                        try {
                            t.commit();
                        }
                        catch (RuntimeException e) {
                            th.addSuppressed(e);
                        }
                        break;
                    }
                    case COMMITTED: 
                    case ROLLEDBACK: {
                        if (!Holder.logger.isDebugEnabled()) break;
                        Holder.logger.debug("In transaction function, explicitly committed/rolledback, so no handle transaction in doTransactiion():" + t);
                        break;
                    }
                    case NONE: {
                        break;
                    }
                }
            }
        }
    }
}

